import { Controller, Get, Inject } from '@midwayjs/core';
import { GitlabService } from '../service/gitlab.service';

@Controller('/')
export class HomeController {
  @Get('/')
  async home(): Promise<string> {
    return 'Hello Midwayjs!';
  }

  @Inject()
  gitlabService: GitlabService;

  @Get('/code')
  async codeStat() {
    const res = await this.gitlabService.getCodeStat();
    return res;
  }
}
