module.exports = {
    publicPath: './',
    assetsDir: 'static',
    productionSourceMap: false,
    chainWebpack: config => {
        config.when(process.env.NODE_ENV === 'production',config => {
            config.entry('app').clear().add('./src/main-prod.js')
        })
        config.when(process.env.NODE_ENV === 'development',config => {
            config.entry('app').clear().add('./src/main-dev.js')
        })
    },
    devServer: {
        open: true,
        port: 8080,
        proxy: {
            '/jacoco': {
                target: 'http://127.0.0.1:8000',
                ws: true,
                changeOrigin: true,
                pathRewrite: { }
            },
            '/accurate': {
                target: 'http://127.0.0.1:8000',
                ws: true,
                changeOrigin: true,
                pathRewrite: { }
            },
            '/api': {
                target: 'http://127.0.0.1:8000',
                ws: true,
                changeOrigin: true,
                pathRewrite: { }
            },
            '/': {
                target: 'http://127.0.0.1:8000',
                ws: true,
                changeOrigin: true,
                pathRewrite: { }
            },
        }
    }
}
