import Vue from 'vue';
import Router from 'vue-router';
import Cookie from 'js-cookie';

/**
 * 懒加载路由
 */
// const Home = () => import(/* webpackChunkName: "home" */ './components/page/Home.vue');
// 首页空白页
const Home = () => import(/* webpackChunkName: "quality" */ './components/common/Home.vue')
const Dashboard = () => import(/* webpackChunkName: "quality" */ './components/page/dashboard.vue')
const Login = () => import(/* webpackChunkName: "quality" */ './components/page/Login.vue')
// 404-403页面
const Home404 = () => import(/* webpackChunkName: "quality" */ './components/page/404.vue')
const Home403 = () => import(/* webpackChunkName: "quality" */ './components/page/403.vue')

// 统计图表
const AutoTestData = () => import(/* webpackChunkName: "quality" */ './components/page/dataModel/AutoTestData.vue')
const CodeCheckData = () => import(/* webpackChunkName: "quality" */ './components/page/dataModel/CodeCheckData.vue')


// 质量平台
const ProjectPage = () => import(/* webpackChunkName: "quality" */ './components/page/common/ProjectPage.vue')
const DepartmentPage =() => import(/* webpackChunkName: "quality" */ './components/page/common/DepartmentPage.vue')
const PublishPage =() => import(/* webpackChunkName: "quality" */ './components/page/publish/PublishPage.vue')
const PublishVersionPage =() => import(/* webpackChunkName: "quality" */ './components/page/publish/PublishVersionPage.vue')
const PublishVersionDetailPage =() => import(/* webpackChunkName: "quality" */ './components/page/publish/PublishVersionDetailPage.vue')
const SubmitPage =() => import(/* webpackChunkName: "quality" */ './components/page/publish/SubmitPage.vue')
const SonarPage =() => import(/* webpackChunkName: "quality" */ './components/page/sonar/SonarResultPage.vue')
const SonarSummaryIssues =() => import(/* webpackChunkName: "quality" */ './components/page/sonar/SonarSummaryIssues.vue')
const SonarSummaryIssuesDetail =() => import(/* webpackChunkName: "quality" */ './components/page/sonar/SonarSummaryIssuesDetail.vue')
const SonarPushIssuesDetail =() => import(/* webpackChunkName: "quality" */ './components/page/sonar/SonarPushIssuesDetail.vue')
const JacocoCreate =() => import(/* webpackChunkName: "quality" */ './components/page/jacoco/JacocoCreate.vue')
const JacocoReport = () => import(/* webpackChunkName: "quality" */ './components/page/jacoco/JacocoReport.vue')
const JavaCallGraph4Callee = () => import(/* webpackChunkName: "quality" */ './components/page/callgraph/JavaCallGraph4Callee.vue')
const JavaCallGraph4Caller = () => import(/* webpackChunkName: "quality" */ './components/page/callgraph/JavaCallGraph4Caller.vue')
const JavaCallGraph4Diff = () => import(/* webpackChunkName: "quality" */ './components/page/callgraph/JavaCallGraph4Diff.vue')
const JavaCallGraphPage = () => import(/* webpackChunkName: "quality" */ './components/page/callgraph/JavaCallGraphPage.vue')
const QueryDiffTaskPage =() => import(/* webpackChunkName: "quality" */ './components/page/apiquerydiff/ApiQueryDiffTask.vue')
const QueryDiffTaskDetailPage =() => import(/* webpackChunkName: "quality" */ './components/page/apiquerydiff/ApiQueryDiffTaskDetail.vue')



// 自动化平台
const UiProject = () => import(/* webpackChunkName: "quality" */ './components/page/uiAutomation/uiProject/UiProject.vue')
const UIProjectPage = () => import(/* webpackChunkName: "quality" */ './components/page/uiAutomation/uiPage/UIProjectPage.vue')
const UiProjectPageElement = () => import(/* webpackChunkName: "quality" */ './components/page/uiAutomation/uiPageElement/uiProjectPageElement.vue')
const UiProjectTestCase = () => import(/* webpackChunkName: "quality" */ './components/page/uiAutomation/uiTestCase/UiProjectTestCase.vue')
const UiProjectTask = () => import(/* webpackChunkName: "quality" */ './components/page/uiAutomation/uiTask/UiProjectTask.vue')
const UiPositioning = () => import(/* webpackChunkName: "quality" */ './components/page/uiAutomation/uiPositioning/UiPositioning.vue')
const UiElementOperation = () => import(/* webpackChunkName: "quality" */ './components/page/uiAutomation/uiElementOperation/UiElementOperation.vue')
// const ApiTaskResult = () => import(/* webpackChunkName: "quality" */ './components/page/apiAutomation/apiTask/ApiTaskResult.vue')
const NewApiTestPlanResult = () => import(/* webpackChunkName: "quality" */ './components/page/apiAutomation/apiTestPlan/newApiTestPlanResult.vue')

const ApiProject = () => import(/* webpackChunkName: "quality" */ './components/page/apiAutomation/apiProject/ApiProject.vue')
const ApiProjectModule = () => import(/* webpackChunkName: "quality" */ './components/page/apiAutomation/apiModule/ApiProjectModule.vue')
const ApiProjectTestCase = () => import(/* webpackChunkName: "quality" */ './components/page/apiAutomation/apiTestCase/ApiProjectTestCase.vue')
const ApiProjectBusinessTest = () => import(/* webpackChunkName: "quality" */ './components/page/apiAutomation/apiBusinessTest/apiProjectBusinessTest.vue')
const ApiProjectTask = () => import(/* webpackChunkName: "quality" */ './components/page/apiAutomation/apiTask/ApiProjectTask.vue')
const ApiEnvironment = () => import(/* webpackChunkName: "quality" */ './components/page/apiAutomation/apiEnvironment/ApiEnvironment.vue')
const AppProject = () => import(/* webpackChunkName: "quality" */ './components/page/appAutomation/appProject/AppProject.vue')
const ApiDatabase = () => import(/* webpackChunkName: "quality" */ './components/page/apiAutomation/apiDatabase/ApiDatabase.vue')
const ApiManagementPage = () => import(/* webpackChunkName: "quality" */ './components/page/apiAutomation/apiManagement/ApiManagementPage.vue')
const ApiScenarioUseCase = () => import(/* webpackChunkName: "quality" */ './components/page/apiAutomation/apiScenarioUseCase/ApiScenarioUseCase.vue')
const ApiTestPlanProject = () => import(/* webpackChunkName: "quality" */ './components/page/apiAutomation/apiTestPlan/apiTestPlanProject.vue')

// const PerformanceReportPage = () => import(/* webpackChunkName: "quality" */ './components/page/performanceAutomation/performanceScript/performanceReportPage.vue')
const PerformanceProject = () => import(/* webpackChunkName: "quality" */ './components/page/performanceAutomation/performanceProject/performanceProject.vue')
const PerformanceProjectScript = () => import(/* webpackChunkName: "quality" */ './components/page/performanceAutomation/performanceScript/performanceProjectScript.vue')
const PerformanceTask = () => import(/* webpackChunkName: "quality" */ './components/page/performanceAutomation/performanceTask/performanceTask.vue')



Vue.use(Router);

const router = new Router({
    // mode: 'history',
    routes: [
        { path: '/login', component: Login, meta: {title: '登录'} },
        {
            path: '/',
            component: Home,
            redirect: '/dashboard',
            meta: {title: '首页'},
            children: [
                { path: '/dashboard', component: Dashboard, meta: {title: '质量平台'} },
                { path: '/data/autoTestData', component: AutoTestData, meta: {title: '自动化数据可视化页面'} },
                { path: '/data/codeCheckData', component: CodeCheckData, meta: {title: '代码检查数据可视化页面'} },
                { path: '/404', component: Home404, meta: {title: '404'} },
                { path: '/403', component: Home403, meta: {title: '403'} },
                // 质量平台菜单
                { path: '/project/page', component: ProjectPage, meta: {title: '项目管理'} },
                { path: '/department/page', component: DepartmentPage, meta: {title: '部门管理'} },
                { path: '/publish/page', component: PublishPage, meta: {title: '发布记录'} },
                { path: '/publish/version/page', component: PublishVersionPage, meta: {title: '发布版本管理'} },
                { path: '/publish/version/detail/page', component: PublishVersionDetailPage, meta: {title: '版本汇总'} },
                { path: '/submit/page', component: SubmitPage, meta: {title: '提测单管理'} },
                { path: '/sonar/result', component: SonarPage, meta: {title: '代码质量检查'} },
                { path: '/sonar/summaryIssues', component: SonarSummaryIssues, meta: {title: '代码检测问题汇总'} },
                { path: '/sonar/summaryIssuesDetail', component: SonarSummaryIssuesDetail, meta: {title: '代码检测问题汇总详情'} },
                { path: '/sonar/pushIssuesDetail', component: SonarPushIssuesDetail, meta: {title: '代码push检测详情'} },
                { path: '/jacoco/create', component: JacocoCreate, meta: {title: '生成覆盖率报告'} },
                { path: '/jacoco/report', component: JacocoReport, meta: {title: '查看覆盖率报告'} },
                { path: '/java/call/graph4callee/create', component: JavaCallGraph4Callee, meta: {title: '生成向上调用链'} },
                { path: '/java/call/graph4caller/create', component: JavaCallGraph4Caller, meta: {title: '生成向下调用链'} },
                { path: '/java/call/graph4diff/create', component: JavaCallGraph4Diff, meta: {title: '生成版本差异调用链'} },
                { path: '/java/call/graph/page', component: JavaCallGraphPage, meta: {title: '调用链查询'} },
                { path: '/querydiff/page', component: QueryDiffTaskPage, meta: {title: 'querydiff任务'} },
                { path: '/querydiff/taskDetail', component: QueryDiffTaskDetailPage, meta: {title: 'querydiff详情'} },
                // 自动化平台菜单
               // { path: '/api_test_task_result', component: ApiTaskResult, meta:{ title: 'Api任务测试报告', requireAuth: false}},
                { path: '/uiProject', component: UiProject, meta: { title: 'UI项目', requireAuth: true }},
                { path: '/uiProjectPage', component: UIProjectPage, meta: { title: 'UI页面管理', requireAuth: true }},
                { path: '/uiProjectPageElement', component: UiProjectPageElement, meta: { title: 'UI页面元素管理', requireAuth: true }},
                { path: '/uiProjectTestCase', component: UiProjectTestCase, meta: { title: 'UI测试用例', requireAuth: true }},
                { path: '/uiProjectTask', component: UiProjectTask, meta: { title: 'UI任务管理', requireAuth: true }},
                { path: '/uiPositioning', component: UiPositioning, meta: { title: 'UI定位', requireAuth: true } },
                { path: '/uiElementOperation', component: UiElementOperation, meta: { title: 'UI元素操作', requireAuth: true } },

                //8.15弃用
                // { path: '/apiProject', component: ApiProject, meta: { title: 'Api项目', requireAuth: true } },
                // { path: '/apiProjectModule', component: ApiProjectModule, meta: { title: 'Api模块', requireAuth: true } },
                // { path: '/apiProjectTestCase', component: ApiProjectTestCase, meta: { title: 'Api测试用例', requireAuth: true } },
                // { path: '/apiBusinessTest', component: ApiProjectBusinessTest, meta: { title: 'Api业务测试', requireAuth: true } },
                // { path: '/apiTask', component: ApiProjectTask, meta: { title: 'Api任务管理', requireAuth: true } },
                { path: '/apiEnvironment', component: ApiEnvironment, meta: { title: 'Api环境设置', requireAuth: true } },
                { path: '/appProject', component: AppProject, meta: { title: 'App项目管理', requireAuth: true } },
                { path: '/apiDatabase', component: ApiDatabase, meta: { title: 'Api数据库管理', requireAuth: true } },
                { path: '/apiManagementPage', component: ApiManagementPage, meta: { title: 'API接口管理', requireAuth: true } },
                { path: '/apiScenarioUseCase', component: ApiScenarioUseCase, meta: { title: 'API场景用例', requireAuth: true } },
                { path: '/apiTestPlan', component: ApiTestPlanProject, meta: { title: 'API测试计划', requireAuth: true } },

                { path: '/performanceProject', component: PerformanceProject, meta: { title: '性能测试项目', requireAuth: true } },
                { path: '/performanceProjectScript', component: PerformanceProjectScript, meta: { title: '性能测试脚本', requireAuth: true } },
                { path: '/performanceTask', component: PerformanceTask, meta: { title: '性能测试任务', requireAuth: true} },
            ]
        },
        {
            path: '/api_test_task_result',
            component: () => import(/* webpackChunkName: "quality" */ './components/page/apiAutomation/apiTask/ApiTaskResult.vue'),
            name: "ApiTaskResult",
            meta:{ title: 'Api任务测试报告', requireAuth: false}
        },
        {
            path: '/api_test_plan_result',
            component: () => import(/* webpackChunkName: "quality" */ './components/page/apiAutomation/apiTestPlan/newApiTestPlanResult.vue'),
            name: "NewApiTestPlanResult",
            meta:{ title: 'Api测试计划报告', requireAuth: false}
        },
        {
            path: '/performanceReportPage',
            component: () => import(/* webpackChunkName: "quality" */ './components/page/performanceAutomation/performanceScript/performanceReportPage.vue'),
            name: "performanceReportPage",
            meta:{ title: '性能测试报告', requireAuth: false}
        },
        { path: '*', redirect: '/404' },
    ]
});

// 通过路由守卫控制访问权限
router.beforeEach((to, from, next) => {
    document.title = `${to.meta.title} | 质量平台` ;
    if (to.path === '/login') {
        next()
    }else {
        next();
        // if (sessionStorage.getItem('TOKEN') || Cookie.get('TOKEN')){
        //     next();
        // }
        // else {
        //     return next(
        //         {
        //             path: '/login',
        //             query: {
        //                 redirect: `${to.fullPath}`,
        //                 path: `${to.path}`
        //             }
        //         }
        //     )
        // }
    }
})

export default router
