import Vue from 'vue';
import App from './App.vue';
import router from './router';
import 'nprogress/nprogress.css'
import {Message, Loading} from 'element-ui';
import axios from 'axios';
import ElementUI from 'element-ui';
import VueI18n from 'vue-i18n';
import 'element-ui/lib/theme-chalk/index.css';
import './assets/css/icon.css';
import './assets/css/main.css';
import 'babel-polyfill';
import api from '/src/assets/js/utils/api'
import Cookie from 'js-cookie'
import * as echarts from 'echarts'
import dataV from '@jiaminghi/data-view'
import JsonViewer from 'vue-json-viewer'
import 'default-passive-events'
import VueClipboard from 'vue-clipboard2'

import {messages} from './components/common/i18n';
import './components/common/directives';

Vue.use(VueClipboard)
Vue.prototype.$echarts = echarts
Vue.config.productionTip = false
Vue.prototype.$message = Message
Vue.prototype.$loading = Loading
Vue.prototype.$http = axios
Vue.prototype.$api = api
Vue.prototype.$Cookie = Cookie
Vue.prototype.$echarts = echarts
Vue.use(dataV)
Vue.use(VueI18n)
Vue.use(JsonViewer)
// ElementUI.TableColumn.props.showOverflowTooltip ={type:Boolean, default: true}
Vue.use(ElementUI, {size: 'small'});
const i18n = new VueI18n({locale: 'zh', messages});

new Vue({
    router,
    i18n,
    render: h => h(App)
}).$mount('#app');
