import {getRequest, postRequest, deleteRequest,putRequest} from "../common/common";

//获取该项目下的场景测试用例树形结构
export const getScenariosCaseTreeRequest = (api_management_id) =>{
    return getRequest("api/backend/api_test_plan/get_scenarios_case_tree/" + api_management_id + "/")
};

//添加API测试计划
export const addAPITestPlanRequest = (data) =>{
    return putRequest("api/backend/api_test_plan/", data)
};

//获取单个Api测试计划
export const getSingleApiTestPlanRequest = (api_test_plan_id) =>{
    return getRequest("api/backend/api_test_plan/" + api_test_plan_id + "/")
};

//删除API测试计划
export const deleteSingleApiTestPlanRequest = (api_test_plan_id) =>{
    return deleteRequest("api/backend/api_test_plan/" + api_test_plan_id + "/")
};

//获取暂停Api测试计划
export const suspendedApiTestPlanRequest = (data) =>{
    return postRequest("api/backend/api_test_plan/suspended/", data)
};

//编辑API测试计划
export const updateSingleApiTestPlanRequest = (api_test_plan_id, data) =>{
    return postRequest("api/backend/api_test_plan/" + api_test_plan_id + "/", data)
};

// 获取该项目---API测试计划列表
export const getApiTestPlanRequest = (api_management_id) =>{
    return getRequest("api/backend/api_test_plan/list/" + api_management_id + "/")
};

//执行API测试计划
export const postPerformApiPlanRequest = (api_test_plan_id) =>{
    return postRequest("api/backend/api_test_plan/perform_api_test_plan/"  +  api_test_plan_id + "/")
};

//查看API测试计划报告列表
export const getApiPlanResultRequest = (api_test_plan_id, size_page, page) =>{
    return getRequest("api/backend/api_test_plan/check_result_list/"  +  api_test_plan_id + "/"  + size_page +  "/" + page + "/")
};


//获取API测试报告列表-API测试用例报告列表
export const getApiTestPlanCheckResultListRequest = (api_test_result_id, size_page, page) =>{
    return getRequest("api/backend/api_test_plan/check_result/" + api_test_result_id + "/" + size_page +  "/" + page + "/")
};

//获取API测试报告列表-API测试用例报告列表-单独APi测试用例报告结果
export const postSingleApiTestPlanCheckResultRequest = (api_test_case_result_id, data) =>{
    return postRequest("api/backend/api_test_plan/single_check_result/" + api_test_case_result_id + "/", data)
};

//删除单独API测试用例的所有测试报告
export const deleteApiTestPlanResultRequest = (api_test_result_id) =>{
    return deleteRequest("api/backend/api_test_plan/check_result/" + api_test_result_id + "/")
};

//获取API测试报告列表-API测试用例报告-失败列表
export const getApiTestPlanCheckResultErrorListRequest = (api_test_result_id, size_page, page) =>{
    return getRequest("api/backend/api_test_plan/check_result/error/" + api_test_result_id +"/" + size_page +  "/" + page + "/")
};