import {getRequest, postRequest, deleteRequest,putRequest} from "../common/common";

// 获取接口用例的树形结构-获取一级/二级/三级目录
export const getApiScenariosCaseRequest = () =>{
    return getRequest("api/backend/api_scenarios_case/list/")
};

// 获取接口用例的树形结构-4级目录获取用例
export const postApiScenariosCaseRequest = (data) =>{
    return postRequest("api/backend/api_scenarios_case/list/", data)
};

// 获取接口项目列表
export const getInterfacesProjectListRequest = () =>{
    return getRequest("api/backend/InterfacesProjectList/list/")
};

// 创建场景测试用例
export const addApiScenariosCaseRequest = (data) =>{
    return putRequest("api/backend/api_scenarios_case/", data)
};

// 获取场景接口用例列表
export const getInterfacesCaseListRequest = (api_management_id) =>{
    return getRequest("api/backend/interfaces_scenarios_case/list/" + api_management_id + "/")
};

// 获取单个场景接口用例
export const getSingleScenariosCaseRequest = (scenarios_case_id) =>{
    return getRequest("api/backend/api_single_scenarios_case/" + scenarios_case_id + "/")
};

// 复制场景测试用例
export const postCopyScenariosCaseRequest = (data) =>{
    return postRequest("api/backend/copy_interfaces_scenarios_case/", data)
};

// 编辑场景接口用例
export const updateScenariosCaseRequest = (scenarios_case_id, data) =>{
    return postRequest("api/backend/api_scenarios_case/" + scenarios_case_id + "/", data)
};


// 删除场景接口用例
export const deleteApiScenariosCaseRequest = (scenarios_case_id) =>{
    return deleteRequest("api/backend/api_scenarios_case/" + scenarios_case_id + "/")
};

//接口场景用例调试
export const postInterfacesScenariosCaseDeBugRequest = (data) =>{
    return postRequest("api/backend/interfaces_scenarios_case/interfaces_scenarios_case_debug/", data)
};

//代表获取 服务、模块、接口、用例关系
export const postServiceModuleInterfacesCaseRelationshipRequest = (data) =>{
    return postRequest("api/backend/interfaces_scenarios_case/ServiceModuleInterfacesCaseRelationship/", data)
};