import {getRequest, postRequest, deleteRequest,putRequest} from "../common/common";

// 获取服务的树形结构-一级目录
export const getApiManagementRequest = () =>{
    return getRequest("api/backend/api_management/list/")
};

// 获取服务的树形结构-按级别查询
export const postApiManagementTreeRequest = (data) =>{
    return postRequest("api/backend/api_management/list/", data)
};

// 接口测试用例调试-debug
export const debugInterfacesCaseRequest = (data) =>{
    return postRequest("api/backend/apiInterfacesCase/debug/", data)
};

// 创建服务
export const putApiManagementRequest = (data) =>{
    return putRequest("api/backend/api_management/list/", data)
};

// 更新服务
export const postApiManagementRequest = (api_management_id, data) =>{
    return postRequest("api/backend/api_management/" + api_management_id + "/",data)
};

// 删除服务
export const deleteApiManagementRequest = (api_management_id) =>{
    return deleteRequest("api/backend/api_management/" + api_management_id + "/")
};

// 获取测试用例列表
export const getApiInterfaceRequest = (api_server_id) =>{
    return getRequest("api/backend/apiInterfacesList/" + api_server_id + "/")
};

// Copy测试用例
export const postApiInterfaceCaseCopyRequest = (data) =>{
    return postRequest("api/backend/apiInterfacesCopyCase/", data)
};

// 新增测试用例
export const putApiInterfaceCaseRequest = (data) =>{
    return putRequest("api/backend/apiInterfacesCase/",data)
};

// 获取单独测试用例
export const getApiInterfaceCaseRequest = (api_interfaces_case_id) =>{
    return getRequest("api/backend/apiInterfacesCase/" + api_interfaces_case_id + "/")
};

// 编辑单独测试用例
export const updateSingleApiInterfaceCaseRequest = (api_interfaces_case_id, data) =>{
    return postRequest("api/backend/apiInterfacesCase/" + api_interfaces_case_id + "/", data)
};

// 删除单个API测试用例
export const deleteSingleInterfaceCaseRequest = (api_interfaces_case_id) =>{
    return deleteRequest("api/backend/apiInterfacesCase/" + api_interfaces_case_id + "/")

};

// 判断 父节点 是否可创建用例（只有用例节点才可创建用例）
export const postJudgeAddCasesRequest = (data) =>{
    return postRequest("api/backend/apiManagement/JudgeAddCases/", data)

};

// 获取YAPI 接口基础参数
export const postYaPiInterfaceRequest = (data) =>{
    return postRequest("api/backend/apiManagement/yaPiInterfaceBasicInformation/", data)

};