# -*- coding: utf-8 -*-
# @Time : 2021/10/21 17:05
# @Author : wangyinghao
# @File : api_database_list_view.py
# @Software: PyCharm
from django.views.generic import View
from automated_main.utils.http_format import response_success
from automated_main.models.api_automation.api_database import APIDatabase
import arrow


class ApiDatabaseListView(View):

    def get(self, request, *args, **kwargs):
        """
        代表获取所有Api数据库列表
        :param request:
        :param args:
        :param kwargs:
        :return:
        """

        api_database = APIDatabase.objects.all()
        api_database_list = []

        for api_databases in api_database:
            api_database_dict = {
                "id": api_databases.id,
                "api_database_title": api_databases.api_database_title,
                "api_host": api_databases.api_host,
                "user": api_databases.user,
                "password": api_databases.password,
                "database": api_databases.database,
                "updata_time": arrow.get(str(api_databases.updata_time)).format('YYYY-MM-DD HH:mm:ss'),
                "create_time": arrow.get(str(api_databases.create_time)).format('YYYY-MM-DD HH:mm:ss'),

            }
            api_database_list.append(api_database_dict)

        return response_success(api_database_list)
