# -*- coding: utf-8 -*-
# @Time    : 2020/12/15 18:07
# @Author  : wangyinghao
# @FileName: ui_page_list_view.py
# @Software: PyCharm
from django.views.generic import View
from automated_main.utils.http_format import response_success
from automated_main.models.ui_automation.ui_page import UIPage
import arrow


class UiPageListView(View):

    def get(self, request, *args, **kwargs):
        """
        代表获取所有UI页面列表
        :param request:
        :param args:
        :param kwargs:
        :return:
        """

        ui_page = UIPage.objects.all()
        ui_page_list = []

        for ui_pages in ui_page:
            page_dict = {
                "id": ui_pages.id,
                "ui_page_name": ui_pages.ui_page_name,
                "ui_page_describe": ui_pages.ui_page_describe,
                "updata_time": arrow.get(str(ui_pages.updata_time)).format('YYYY-MM-DD HH:mm:ss'),
                "create_time": arrow.get(str(ui_pages.create_time)).format('YYYY-MM-DD HH:mm:ss'),
                "ui_project_name": ui_pages.ui_project.ui_project_name
            }
            ui_page_list.append(page_dict)

        return response_success(ui_page_list)

