# -*- coding: utf-8 -*-
# @Time : 2022/7/21 14:47
# @Author : wangyinghao
# @Site : 
# @File : api_test_plan_list_view.py
# @Software: PyCharm
from django.views.generic import View
from automated_main.utils.http_format import response_success
from automated_main.models.api_automation.api_test_plan import ApiTestPlan
import arrow


class ApiTestPlanListView(View):

    def get(self, request, api_management_id, *args, **kwargs):
        """
        代表获取所有API测试任务
        :param request:
        :param api_management_id: API项目id
        :param args:
        :param kwargs:
        :return:
        """
        status = None
        api_test_plan_data = ApiTestPlan.objects.filter(api_management_id=api_management_id).order_by('-id')
        api_test_plan_list = []
        for api_test_plan in api_test_plan_data:
            if api_test_plan.status == 0:
                status = "未执行"
            elif api_test_plan.status == 1:
                status = "执行中"
            elif api_test_plan.status == 2:
                status = "已完成"
            api_task_dict = {
                "id": api_test_plan.id,
                "api_test_plan_describe": api_test_plan.api_test_plan_describe,
                "cases": api_test_plan.cases,
                "api_test_plan_name": api_test_plan.api_test_plan_name,
                "api_send_email": api_test_plan.api_send_email,
                "api_send_enterprise_wechat": api_test_plan.api_send_enterprise_wechat,
                "api_environment_id": api_test_plan.api_environment_id,
                "database_id": api_test_plan.database_id,
                "timing_task_status": api_test_plan.timing_task_status,
                "time_interval_seconds": api_test_plan.time_interval_seconds,
                "time_interval_hours": api_test_plan.time_interval_hours,
                "time_interval_minutes": api_test_plan.time_interval_minutes,
                "time_interval_day": api_test_plan.time_interval_day,
                "end_time": api_test_plan.end_time,
                "starting_time": api_test_plan.starting_time,
                "status": status,
                "update_time": arrow.get(str(api_test_plan.update_time)).format('YYYY-MM-DD HH:mm:ss'),
                "create_time": arrow.get(str(api_test_plan.create_time)).format('YYYY-MM-DD HH:mm:ss'),

            }
            api_test_plan_list.append(api_task_dict)

        return response_success(api_test_plan_list)
