# -*- coding: utf-8 -*-
# @Time : 2022/3/21 17:21
# @Author : wangyinghao
# @Site : 
# @File : api_test_case_excel.py
# @Software: PyCharm
"""
excel类
1、读取表头
2、读取数据 - 读取表头以外的所有数据。 - 返回值：列表，成员是每一行数据

初始化工作  加载一个excel,打开一个表单。

"""
from openpyxl import load_workbook
import json


class HandleExcel:

    def __init__(self, file_path, sheet_name, i=1, actual_results=None, variable_value=None, test_results=None):
        """
        :param file_path: excel地址
        :param sheet_name: Sheet名称
        :param i:
        :param actual_results:实际结果
        :param variable_value:变量结果
        :param test_results: 测试结果
        """
        self.test_results = test_results
        self.variable_value = variable_value
        self.file_path = file_path
        self.wb = load_workbook(file_path)
        self.sh = self.wb[sheet_name]
        self.i = i
        self.actual_results = actual_results

    def __read_titles(self):
        titles = []
        for item in list(self.sh.rows)[1]:  # 遍历第2行当中每一列
            titles.append(item.value)
        return titles

    def read_all_datas(self):
        all_datas = []
        titles = self.__read_titles()
        for item in list(self.sh.rows)[2:]:  # 遍历数据行
            values = []
            for val in item:  # 获取每一行的值
                values.append(val.value)
            res = dict(zip(titles, values))  # title和每一行数据，打包成字典
            all_datas.append(res)
        return all_datas

    def write_datas(self):
        self.sh.cell(self.i, 9).value = self.actual_results
        if self.sh.cell(self.i, 11).value is None or "":
            self.sh.cell(self.i, 13).value = self.test_results
            self.wb.save(self.file_path)
        else:
            self.sh.cell(self.i, 12).value = self.variable_value
            self.sh.cell(self.i, 13).value = self.test_results
            self.wb.save(self.file_path)

    def close_file(self):
        self.wb.close()


if __name__ == '__main__':
    he = HandleExcel("d:\\上传接口.xlsx", "Sheet1")
    cases1 = he.read_all_datas()
    print(len(cases1))

    case_list = []

    for i in range(len(cases1)):

        case_dict = {
            "项目名称": str(cases1[i]['项目名称']).replace("\n", ""),
            "模块": str(cases1[i]['模块']).replace("\n", ""),
            "测试用例名称": str(cases1[i]['测试用例名称']).replace("\n", ""),
            "域名": str(cases1[i]['域名']).replace("\n", ""),
            "请求方式": str(cases1[i]['请求方式']).replace("\n", ""),
            "请求地址": str(cases1[i]['请求地址']).replace("\n", ""),
            "请求头": str(cases1[i]['请求头']).replace("\n", ""),
            "Params": str(cases1[i]['Params']).replace("\n", ""),
            "参数类型": str(cases1[i]['参数类型']).replace("\n", ""),
            "body类型": str(cases1[i]['body类型']).replace("\n", ""),
            "body": str(cases1[i]['body']).replace("\n", ""),
            "断言类型": str(cases1[i]['断言类型']).replace("\n", ""),
            "数据库环境": str(cases1[i]['数据库环境']).replace("\n", ""),
            "数据库语句": str(cases1[i]['数据库语句']).replace("\n", ""),
            "断言内容": str(cases1[i]['断言内容']).replace("\n", ""),
            "提取表达式": str(cases1[i]['提取表达式']).replace("\n", ""),
            "变量名称": str(cases1[i]['变量名称']).replace("\n", "")

        }

        print(case_dict)


