# -*- coding: utf-8 -*-
# @Time    : 2021/3/2 18:41
# @Author  : wangyinghao
# @FileName: api_project_list_view.py
# @Software: PyCharm
from django.views.generic import View
from automated_main.utils.http_format import response_success
from automated_main.models.api_automation.api_project import APIProject
import arrow


class ApiProjectListView(View):

    def get(self, request, *args, **kwargs):
        """
        代表获取所有API测试项目列表
        :param request:
        :param args:
        :param kwargs:
        :return:
        """

        api_projects = APIProject.objects.all().order_by('-id')
        api_project_list = []

        for api_project in api_projects:
            api_project_dict = {
                "id": api_project.id,
                "api_project_name": api_project.api_project_name,
                "describe": api_project.describe,
                "updata_time": arrow.get(str(api_project.updata_time)).format('YYYY-MM-DD HH:mm:ss'),
                "create_time": arrow.get(str(api_project.create_time)).format('YYYY-MM-DD HH:mm:ss'),
            }
            api_project_list.append(api_project_dict)

        return response_success(api_project_list)
