# -*- coding: utf-8 -*-
# @Time    : 2021/3/25 15:28
# @Author  : wangyinghao
# @FileName: api_environment_view.py
# @Software: PyCharm
from django.views.generic import View
import json
from django.forms import model_to_dict
from automated_main.utils.http_format import response_success
from automated_main.exception.my_exception import MyException
from automated_main.models.api_automation.api_environment import APIEnvironment
from automated_main.models.api_automation.api_environment import APIGlobalVariable
from automated_main.form.api_environment import ApiEnvironmentForm


class ApiEnvironmentView(View):

    def get(self, request, api_environment_id, *args, **kwargs):
        """
        代表获取单个API环境
        :param request:
        :param api_environment_id:
        :param args:
        :param kwargs:
        :return:
        """

        api_environment = APIEnvironment.objects.filter(id=api_environment_id).first()

        api_environment_data = model_to_dict(api_environment)
        api_global_variable = APIGlobalVariable.objects.filter(api_environment_id=api_environment_id)
        global_variable_list = []

        if api_global_variable.count() == 0:
            global_variable_dict = {
                "api_global_variable_name": "",
                "api_global_variable_value": "",
                "api_global_variable_describe": ""
            }
            global_variable_list.append(global_variable_dict)
            api_environment_data["global_variable"] = global_variable_list

        else:
            for global_variable in api_global_variable:
                global_variable_dict = {
                    "api_global_variable_name": global_variable.api_global_variable_name,
                    "api_global_variable_value": global_variable.api_global_variable_value,
                    "api_global_variable_describe": global_variable.api_global_variable_describe
                }
                global_variable_list.append(global_variable_dict)
            api_environment_data["global_variable"] = global_variable_list

        if api_environment is None:
            return response_success()
        else:
            return response_success(api_environment_data)

    def post(self, request, api_environment_id, *args, **kwargs):
        """
        代表更改API环境
        :param request:
        :param api_environment_id:
        :param args:
        :param kwargs:
        :return:
        """
        api_environment = APIEnvironment.objects.filter(id=api_environment_id).first()
        if api_environment is None:
            return response_success()
        body = request.body
        if not body:
            return response_success()
        data = json.loads(body)
        form = ApiEnvironmentForm(data)

        if form.is_valid():
            APIEnvironment.objects.filter(id=api_environment_id).update(**form.cleaned_data)

            if APIGlobalVariable.objects.filter(api_environment_id=api_environment_id).count() >= 0:
                APIGlobalVariable.objects.filter(api_environment_id=api_environment_id).delete()

                for global_variable in data['global_variable_data']:
                    APIGlobalVariable.objects.create(
                        api_environment_id=api_environment_id,
                        api_global_variable_name=global_variable['api_global_variable_name'],
                        api_global_variable_value=global_variable['api_global_variable_value'],
                        api_global_variable_describe=global_variable['api_global_variable_describe'],
                    )

            return response_success("编辑API环境成功")
        else:
            raise MyException()

    def delete(self, request, api_environment_id, *args, **kwargs):
        """
        代表删除单独API环境
        :param request:
        :param api_environment_id: API环境ID
        :param args:
        :param kwargs:
        :return:
        """

        APIEnvironment.objects.filter(id=api_environment_id).delete()
        return response_success("删除API环境成功")

    def put(self, request, *args, **kwargs):
        """
        代表创建API环境
        :param request:
        :param args:
        :param kwargs:
        :return:
        """

        body = request.body
        if not body:
            return response_success()
        data = json.loads(body)

        form = ApiEnvironmentForm(data)

        if form.is_valid():
            api_environment = APIEnvironment.objects.create(**form.cleaned_data)
            api_environment.save()

            if APIGlobalVariable.objects.filter(api_environment_id=api_environment.id).count() >= 0:
                APIGlobalVariable.objects.filter(api_environment_id=api_environment.id).delete()

                for global_variable in data['global_variable_data']:
                    APIGlobalVariable.objects.create(
                        api_environment_id=api_environment.id,
                        api_global_variable_name=global_variable['api_global_variable_name'],
                        api_global_variable_value=global_variable['api_global_variable_value'],
                        api_global_variable_describe=global_variable['api_global_variable_describe'],
                    )

            return response_success("创建成功")
        else:
            raise MyException(message="创建失败")
