# -*- coding: utf-8 -*-
"""
@Time ： 2021/6/21 11:04
@Auth ： WangYingHao
@File ：performance_script_url.py
@IDE ：PyCharm

"""
from django.urls import path
from automated_main.view.performance_test.performance_script.performance_script_list_view import \
    PerformanceScriptListView
from automated_main.view.performance_test.performance_script.performance_script_view import PerformanceScriptView, \
    PerformanceProjectScriptView, PerformanceScriptUpload, PerformPerformanceScript, PerformanceScriptReport, \
    PerformanceProjectScriptSuspendedView, PerformanceScriptDataSetUpload, NewPerformPerformanceScript, PerformanceScriptReportPage

urlpatterns = [

    path("api/backend/performance_test/performance_script_list/", PerformanceScriptListView.as_view()),

    path("api/backend/performance_test/performance_script/", PerformanceScriptView.as_view()),
    path("api/backend/performance_test/performance_script/<int:performance_script_id>/",
         PerformanceScriptView.as_view()),

    # 获取 单个性能测试项目中包含得所有性能脚本
    path(
        "api/backend/performance_test/performance_project_script/<int:performance_project_id>/<int:size_page>/<int:page>/",
        PerformanceProjectScriptView.as_view()),

    # 搜索-查看脚本名称
    path("api/backend/performance_test/performance_project_script/<int:size_page>/<int:page>/",
         PerformanceProjectScriptView.as_view()),

    # 暂停执行jmeter
    path("api/backend/performance_test/performance_project_script/script_suspended/<int:performance_script_id>/",
         PerformanceProjectScriptSuspendedView.as_view()),

    # 上传性能测试脚本
    path("api/backend/performance_test/performance_script_upload/", PerformanceScriptUpload.as_view(), name="upload"),

    # 上传性能测试脚本参数化
    path("api/backend/performance_test/performance_script_data_set_upload/", PerformanceScriptDataSetUpload.as_view(), name="upload"),

    # 执行性能脚本
    path("api/backend/performance_test/perform_performance_script/<int:performance_script_id>/",
         PerformPerformanceScript.as_view()),

    # New执行性能脚本
    path("api/backend/performance_test/new_perform_performance_script/<int:performance_script_id>/",
         NewPerformPerformanceScript.as_view()),

    # 性能测试报告
    path("api/backend/performance_test/performance_script_report/<int:performance_script_id>/",
         PerformanceScriptReport.as_view()),

    # New性能测试报告
    path("api/backend/performance_test/performance_script_report/",
         PerformanceScriptReport.as_view()),
    # 性能测试报告 -删除
    path("api/backend/performance_test/performance_script_report/<str:report_name>/<int:report_id>/",
         PerformanceScriptReport.as_view()),

    # 性能测试报告页面获取数据-单独页面
    path("api/backend/performance_test/performance_script_report_page/<int:performance_report_id>/",
         PerformanceScriptReportPage.as_view()),


]
