# -*- coding: utf-8 -*-

from django.db import models


class QuerryDiffTask(models.Model):
    """
    回放任务
    """
    task_name = models.CharField("回放任务名称", max_length=100, blank=False, default="")
    source_env_id = models.IntegerField("基准环境id", blank=False)
    target_env_id = models.IntegerField("测试环境id", blank=False)
    log_time = models.TextField("关联API用例", default="")
    project_id = models.IntegerField("无效字段去除", blank=False, null=True)
    simple_num = models.IntegerField("单接口样本量", blank=False)

    urls = models.JSONField("指定url",  blank=True, null=True)
    opt_num = models.IntegerField("运行次数", default=0, null=True)
    status = models.IntegerField("状态", default=0, null=True)

    created_name = models.CharField("创建人", max_length=255, blank=True, default="", null=True)
    created_time = models.DateTimeField("创建时间", auto_now_add=True)

    def __str__(self):
        return self.task_name
