# -*- coding: utf-8 -*-
"""
@Time ： 2021/5/27 17:45
@Auth ： WangYingHao
@File ：performance_script_view.py
@IDE ：PyCharm

"""
import json
import os
import random
import time
import arrow
import shutil
from django.views.generic import View
from automated_main.view.performance_test.performance_script.extend.performance_task_thread import TaskThread
from automated_main.view.performance_test.performance_script.extend.new_performance_task_thread import NewTaskThread
from automated_main.view.performance_test.performance_script.extend.report_jtl import TaskThread22

from AutomatedTestPlatform import settings
from automated_main.exception.my_exception import MyException
from automated_main.form.performance_script import PerformanceScriptForm
from automated_main.models.performance_test.performance_script import PerformanceScript
from automated_main.utils.http_format import response_success, response_failed
from django.conf import settings
from django.core.paginator import Paginator
from automated_main.models.performance_test.performance_report import PerformanceReport, PerformanceReportError
from pathlib import Path
from django.db.models import Q
from automated_main.utils.jmeter_perform import create_para_jmx
import logging
import csv
import pandas as pd
import numpy as np
from functools import reduce

logger = logging.getLogger('django')


class PerformanceScriptView(View):

    def get(self, request, performance_script_id, *args, **kwargs):
        """
        代表获取单个性能脚本
        :param request:
        :param performance_script_id:
        :param args:
        :param kwargs:
        :return:
        """

        performance_script = PerformanceScript.objects.filter(id=performance_script_id)
        performance_script_dict = PerformanceScript.objects.get(id=performance_script_id)

        logger.info(performance_script_dict.performance_script_name)

        jmeter_list = []
        jmeter_data = []
        for performance_scripts in performance_script:
            jmeter_script_name = os.path.basename(performance_scripts.performance_script).split('-')[-1]
            performance_jmeter_script_dict = {
                "url": performance_scripts.performance_script,
                "name": jmeter_script_name,
            }
            if performance_scripts.performance_data_script is None:
                performance_jmeter_data_dict = {
                    "data_url": performance_scripts.performance_data_script,
                    "data_name": "",
                }
            else:
                jmeter_data_name = os.path.basename(performance_scripts.performance_data_script).split('-')[-1]
                performance_jmeter_data_dict = {
                    "url": performance_scripts.performance_data_script,
                    "name": jmeter_data_name,
                }
            jmeter_data.append(performance_jmeter_data_dict)

            jmeter_list.append(performance_jmeter_script_dict)

        if performance_script is None:
            return response_success()
        else:
            return response_success(
                {
                    "performance_script_name": performance_script_dict.performance_script_name,
                    "performance_script_id": performance_script_dict.id,
                    "performance_threads": performance_script_dict.performance_threads,
                    "performance_ramp_up_time_seconds": performance_script_dict.performance_ramp_up_time_seconds,
                    "performance_loop_count": performance_script_dict.performance_loop_count,
                    "performance_duration": performance_script_dict.performance_duration,
                    "loop_count_forever": performance_script_dict.loop_count_forever,
                    "performance_scheduler": performance_script_dict.performance_scheduler,
                    "performance_project_id": performance_script_dict.performance_project_id,
                    "performance_script_url": jmeter_list,
                    "performance_script_data": performance_script_dict.performance_data_script,
                    "data_set": performance_script_dict.data_set,
                    "performance_script_data_url": jmeter_data
                }
            )

    def post(self, request, performance_script_id, *args, **kwargs):
        """
        代表更改性能脚本
        :param request:
        :param performance_script_id:
        :param args:
        :param kwargs:
        :return:
        """
        performance_script = PerformanceScript.objects.filter(id=performance_script_id).first()
        if performance_script is None:
            return response_success()
        body = request.body
        if not body:
            return response_success()
        data = json.loads(body)

        form = PerformanceScriptForm(data)

        if form.is_valid():
            PerformanceScript.objects.filter(id=performance_script_id).update(**form.cleaned_data)
            return response_success("编辑性能脚本成功")
        else:
            raise MyException(message=form.errors)

    def delete(self, request, performance_script_id, *args, **kwargs):
        """
        代表删除单独性能脚本
        :param request:
        :param performance_script_id:
        :param args:
        :param kwargs:
        :return:
        """

        PerformanceScript.objects.filter(id=performance_script_id).delete()
        return response_success("删除单独性能脚本")

    def put(self, request, *args, **kwargs):
        """
        代表创建性能脚本
        :param request:
        :param args:
        :param kwargs:
        :return:
        """

        body = request.body
        if not body:
            return response_success()
        data = json.loads(body)

        form = PerformanceScriptForm(data)

        if form.is_valid():

            PerformanceScript.objects.create(**form.cleaned_data)
            return response_success("创建成功")
        else:
            raise MyException(message="创建失败")


class PerformanceProjectScriptSuspendedView(View):

    def get(self, request, performance_script_id, *args, **kwargs):
        """
        暂停性能脚本运行
        :param performance_script_id:
        :param request:
        :param args:
        :param kwargs:
        :return:
        """
        os.system("kill -9 `ps aux | grep jmeter | grep -v grep | awk '{print $2}'`")

        performance_script = PerformanceScript.objects.get(id=performance_script_id)
        performance_script.performance_status = 2
        performance_script.save()

        return response_success("已暂停")


class PerformanceProjectScriptView(View):

    def get(self, request, performance_project_id, size_page, page, *args, **kwargs):
        """
        获取 单个性能项目中包含得所有脚本
        :param page: 页数
        :param size_page: 页码
        :param performance_project_id:
        :param request:
        :param args:
        :param kwargs:
        :return:
        """
        performance_script = PerformanceScript.objects.filter(performance_project_id=performance_project_id).order_by(
            '-id')

        performance_script_list = []
        for performance_scripts in performance_script:

            if performance_scripts.performance_status == 0:
                status = "未执行"
            elif performance_scripts.performance_status == 1:
                status = "执行中"
            elif performance_scripts.performance_status == 2:
                status = "已完成"
            performance_script_dict = {
                "id": performance_scripts.id,
                "performance_project_name": performance_scripts.performance_project.performance_project_name,
                "performance_script_name": performance_scripts.performance_script_name,
                "performance_script": performance_scripts.performance_script,
                "performance_script_data": performance_scripts.performance_data_script,
                "performance_status": status,
                "updata_time": arrow.get(str(performance_scripts.updata_time)).format('YYYY-MM-DD HH:mm:ss'),
                "create_time": arrow.get(str(performance_scripts.create_time)).format('YYYY-MM-DD HH:mm:ss'),
            }
            performance_script_list.append(performance_script_dict)
        p = Paginator(performance_script_list, size_page)
        page1 = p.page(page)
        current_page = page1.object_list
        total_script = len(performance_script_list)

        if performance_script is None:
            return response_success()
        else:
            return response_success({'status': 200, 'data': current_page, 'total_script': total_script})

    def post(self, request, size_page, page, *args, **kwargs):
        """
        搜索-脚本
        :param page:
        :param size_page:
        :param request:
        :param args:
        :param kwargs:
        :return:
        """

        body = request.body
        if not body:
            return response_success()
        data = json.loads(body)
        if data['performance_script_name'] is None or "":
            performance_scripts = PerformanceScript.objects.filter(
                performance_project_id=data['performance_project_id'])
        else:
            performance_scripts = PerformanceScript.objects.filter(
                performance_project_id=data['performance_project_id'],
                performance_script_name__contains=data['performance_script_name'])
        performance_script_list = []
        for performance_script in performance_scripts:
            if performance_script.performance_status == 0:
                status = "未执行"
            elif performance_script.performance_status == 1:
                status = "执行中"
            elif performance_script.performance_status == 2:
                status = "已完成"
            performance_script_dict = {
                "id": performance_script.id,
                "performance_project_name": performance_script.performance_project.performance_project_name,
                "performance_script_name": performance_script.performance_script_name,
                "performance_script": performance_script.performance_script,
                "performance_status": status,
                "updata_time": arrow.get(str(performance_script.updata_time)).format('YYYY-MM-DD HH:mm:ss'),
                "create_time": arrow.get(str(performance_script.create_time)).format('YYYY-MM-DD HH:mm:ss'),
            }
            performance_script_list.append(performance_script_dict)
        p = Paginator(performance_script_list, size_page)
        page1 = p.page(page)
        current_page = page1.object_list
        total_script = len(performance_script_list)

        return response_success({'status': 200, 'data': current_page, 'total_script': total_script})


class PerformanceScriptUpload(View):

    def post(self, request, *args, **kwargs):
        """
        上传脚本
        :param request:
        :param args:
        :param kwargs:
        :return:
        """
        file_obj = request.FILES.get("file")
        name = file_obj.name
        fn = time.strftime("%Y-%m-%d-%H-%M-%S", time.localtime())
        fn = fn + '-%d' % random.randint(0, 100)

        path = os.path.join(settings.JMETER_ROOT, fn + '-' + name)

        with open(path, "wb") as f_write:
            for line in file_obj:
                f_write.write(line)

        return response_success({"file": 'http://' + request.get_host() + "/api/jmeter_script/" + fn + '-' + name,
                                 "result": "OK",
                                 "fileName": name,
                                 "path": path})


class PerformanceScriptDataSetUpload(View):

    def post(self, request, *args, **kwargs):
        """
        性能脚本参数化
        :param request:
        :param args:
        :param kwargs:
        :return:
        """
        file_obj = request.FILES.get("file")
        name = file_obj.name
        fn = time.strftime("%Y-%m-%d-%H-%M-%S", time.localtime())
        fn = fn + '-%d' % random.randint(0, 100)

        path = os.path.join(settings.JMETER_DATA_SET_ROOT, fn + '-' + name)

        with open(path, "wb") as f_write:
            for line in file_obj:
                f_write.write(line)
        ENV_PROFILE = os.getenv("ENV")
        if ENV_PROFILE == "SERVER":
            ip = 'http://'
        elif ENV_PROFILE == "1":
            ip = 'http://'
        else:
            ip = 'http://'
        return response_success({"file": ip + request.get_host() + "/api/jmeter_script_data_set/" + fn + '-' + name,
                                 "result": "OK",
                                 "fileName": name,
                                 "path": path})


class PerformPerformanceScript(View):

    def get(self, request, performance_script_id, *args, **kwargs):
        """
        执行Jmeter脚本
        :param performance_script_id: 性能脚本ID
        :param request:
        :param args:
        :param kwargs:
        :return:
        """
        if performance_script_id == "":
            return response_failed({"status": 10102, "message": "performance_script_id不能为空"})

        performance_script_tasks = PerformanceScript.objects.all()

        # for t in performance_script_tasks:
        #     if t.performance_status == 1:
        #         return response_failed({"status": 10200, "message": "当前有任务正在执行！"})
        try:
            performance_script = PerformanceScript.objects.get(id=performance_script_id)
            # 更改运行状态
            performance_script.performance_status = 1
            performance_script.save()

            TaskThread(performance_script_id, request.get_host()).run()
            result = "开始执行性能脚本"
        except Exception as e:
            result = e
            logger.info("这是报错" + e)

        return response_success(result)


class NewPerformPerformanceScript(View):

    def get(self, request, performance_script_id, *args, **kwargs):
        """
        执行Jmeter脚本
        :param performance_script_id: 性能脚本ID
        :param request:
        :param args:
        :param kwargs:
        :return:
        """
        if performance_script_id == "":
            return response_failed({"status": 10102, "message": "performance_script_id不能为空"})

        try:
            performance_script = PerformanceScript.objects.get(id=performance_script_id)
            # 更改运行状态
            performance_script.performance_status = 1
            performance_script.save()

            NewTaskThread(performance_script_id, request.get_host()).run()
            result = "开始执行性能脚本"
        except Exception as e:
            result = e
            logger.info("这是报错" + e)

        return response_success(result)


class PerformanceScriptReport(View):

    def get(self, request, performance_script_id, *args, **kwargs):
        """
        查看测试报告
        :param request:
        :param performance_script_id: 性能脚本id
        :param args:
        :param kwargs:
        :return:
        """
        if performance_script_id == "":
            return response_failed({"status": 10102, "message": "performance_script_id不能为空"})
        performance_script_report_list = []
        performance_reports = PerformanceReport.objects.filter(performance_script_id=performance_script_id).order_by(
            '-id')
        for performance_report in performance_reports:
            performance_script_report_dict = {
                "performance_script_report_name": performance_report.performance_report_name,
                "performance_report_id": performance_report.id,
                "file": performance_report.file,
                "pressure_test_content": performance_report.pressure_test_content,
                "create_time": arrow.get(str(performance_report.create_time)).format('YYYY-MM-DD HH:mm:ss')
            }
            performance_script_report_list.append(performance_script_report_dict)
        return response_success(performance_script_report_list)

    def delete(self, request, report_name, report_id, *args, **kwargs):
        """
        代表删除单独性能测试报告
        :param report_id: 测试报告id
        :param report_name: 测试报告名称
        :param request:
        :param args:
        :param kwargs:
        :return:
        """
        if report_id == "":
            return response_failed({"status": 10102, "message": "report_id不能为空"})

        PerformanceReport.objects.filter(id=report_id).delete()
        dir = settings.JMETER_REPORT
        dir_list = os.listdir(dir)
        for report in dir_list:
            if report == str(report_name):

                ENV_PROFILE = os.getenv("ENV")
                if ENV_PROFILE == "SERVER":
                    dirPath = '/data/jmeter_report/Report/'
                elif ENV_PROFILE == "1":
                    dirPath = 'D:/jmeter_report/Report/'

                logger.info('移除前test目录：%s' % os.listdir(dirPath))
                shutil.rmtree(dirPath + report_name)
                logger.info('移除后test目录：%s' % os.listdir(dirPath))

            else:
                pass
        return response_success('删除成功')

    def post(self, request, *args, **kwargs):
        """
        查看测试报告
        :param request:
        :param args:
        :param kwargs:
        :return:
        """
        body = request.body
        data = json.loads(body)
        performance_script_report_list = []
        ENV_PROFILE = os.getenv("ENV")
        for report_id in data:
            performance_reports = PerformanceReport.objects.filter(id=report_id['performance_report_id'])
            for performance_report in performance_reports:

                dir_jmeter = settings.JMETER_REPORT
                dir_list = os.listdir(dir_jmeter)
                for report in dir_list:
                    if report == str(performance_report.performance_report_name):
                        dirPath = dir_jmeter + '/' + report + '/' + report + '-aggregate.csv'
                        dirResponseCodesPerSecond = dir_jmeter + '/' + report + '/' + report + '-response_codes_per_second.csv'
                        jmeter_jtl = dir_jmeter + '/' + report + '/' + report + '.jtl'

                        report_dict = {}
                        report_list = []

                        # 图表标题
                        title = {}

                        tooltip = {
                                      "trigger": "axis"
                                  },

                        toolbox = {
                            "feature": {
                                "saveAsImage": {}
                            }
                        }

                        # 获取api名称
                        legend = {
                            "data": [],
                            "show": bool(True),
                            "top": "6%"
                        }

                        # 获取横坐标
                        xAxis = {
                            "type": 'category'
                        }

                        # 纵坐标
                        yAxis = {
                            "type": "value"
                        }

                        grid = {
                                   "left": '3%',
                                   "right": '4%',
                                   "bottom": '3%',
                                   "containLabel": 'true'
                               },

                        # api组合数据
                        series_data = []

                        per_second = Path(dirResponseCodesPerSecond)
                        if per_second.is_file():
                            with open(per_second, 'r') as csvFile:
                                reader_per_second = csv.reader(csvFile)
                                for line in reader_per_second:
                                    b = 1
                                    if reader_per_second.line_num == 1:
                                        for aa in range(len(line) - 1):
                                            series_dict = {
                                                "name": line[b + aa],
                                                "type": 'line',
                                                'connectNulls': bool(True)
                                            }

                                            # 获取series数据
                                            if ENV_PROFILE == "SERVER":
                                                response_codes_per_second_data = pd.read_csv(per_second,
                                                                                             encoding="utf-8",
                                                                                             usecols=[b + aa],
                                                                                             index_col=0)
                                            elif ENV_PROFILE == "1":
                                                response_codes_per_second_data = pd.read_csv(per_second,
                                                                                             encoding="gb18030",
                                                                                             usecols=[b + aa],
                                                                                             index_col=0)
                                            else:
                                                response_codes_per_second_data = pd.read_csv(per_second,
                                                                                             encoding="utf-8",
                                                                                             usecols=[b + aa],
                                                                                             index_col=0)

                                            response_codes_per_second_data_tolist = response_codes_per_second_data.index.tolist()

                                            response_codes_per_second_data_list = ["" if str(x) == "nan" else x for x in
                                                                                   response_codes_per_second_data_tolist]

                                            series_dict['data'] = response_codes_per_second_data_list

                                            series_data.append(series_dict)

                                            # api名称
                                            legend['data'].append(line[b + aa])

                                            # 获取横坐标
                                            if ENV_PROFILE == "SERVER":
                                                elapsed_time = pd.read_csv(per_second, encoding="utf-8",
                                                                           usecols=['Elapsed time'],
                                                                           index_col=0).index.tolist()

                                            elif ENV_PROFILE == "1":
                                                elapsed_time = pd.read_csv(per_second, encoding="gb18030",
                                                                           usecols=['Elapsed time'],
                                                                           index_col=0).index.tolist()
                                            else:
                                                elapsed_time = pd.read_csv(per_second, encoding="utf-8",
                                                                           usecols=['Elapsed time'],
                                                                           index_col=0).index.tolist()
                                            xAxis['data'] = elapsed_time

                            if performance_report.pressure_test_content is None or "":
                                chart = ""
                            else:
                                chart = performance_report.pressure_test_content

                            title['text'] = "响应时间随时间变化-" + chart
                            per = {
                                "title": title,
                                "tooltip": tooltip,
                                "legend": legend,
                                "grid": grid,
                                "toolbox": toolbox,
                                "xAxis": xAxis,
                                "yAxis": yAxis,
                                "series": series_data

                            }
                            report_dict['response_time_varies_over_time'] = per

                            jtl_error_list = []
                            report_error = PerformanceReportError.objects.filter(
                                performance_report_id=performance_report.id)
                            for report_error_jtl in report_error:
                                jtl_error_dict = {
                                    "jtl_error": str(report_error_jtl.performance_report_error_name)
                                }
                                jtl_error_list.append(jtl_error_dict)
                            report_dict['jtl_error'] = jtl_error_list

                        else:

                            jtl_error_list = []
                            report_error = PerformanceReportError.objects.filter(
                                performance_report_id=performance_report.id)
                            for report_error_jtl in report_error:
                                jtl_error_dict = {
                                    "jtl_error": str(report_error_jtl.performance_report_error_name)
                                }
                                jtl_error_list.append(jtl_error_dict)
                            report_dict['jtl_error'] = jtl_error_list

                            ENV_PROFILE = os.getenv("ENV")
                            if ENV_PROFILE == "SERVER":
                                CMDRUNNER = '$CMDRUNNER'
                            elif ENV_PROFILE == "1":
                                CMDRUNNER = os.getenv('CmdRunner')

                            else:
                                CMDRUNNER = '$CMDRUNNER'
                            for performance_report in performance_reports:
                                # 响应时间随时间变化曲线
                                response_codes_per_second_report = 'java -jar ' + CMDRUNNER + ' --tool Reporter --generate-csv ' + dirResponseCodesPerSecond + ' --input-jtl ' + settings.JMETER_REPORT + "/" + str(
                                    performance_report.performance_report_name) + "/" + str(
                                    performance_report.performance_report_name) + ".jtl" + ' --plugin-type ResponseTimesOverTime'

                                os.system(response_codes_per_second_report)
                                with open(per_second, 'r') as csvFile:
                                    reader_per_second = csv.reader(csvFile)
                                    for line in reader_per_second:
                                        b = 1
                                        if reader_per_second.line_num == 1:
                                            for aa in range(len(line) - 1):
                                                series_dict = {
                                                    "name": line[b + aa],
                                                    "type": 'line',
                                                    'connectNulls': bool(True)
                                                }

                                                # 获取series数据
                                                if ENV_PROFILE == "SERVER":
                                                    response_codes_per_second_data = pd.read_csv(per_second,
                                                                                                 encoding='utf-8',
                                                                                                 usecols=[b + aa],
                                                                                                 index_col=0)

                                                elif ENV_PROFILE == "1":
                                                    response_codes_per_second_data = pd.read_csv(per_second,
                                                                                                 encoding='gb18030',
                                                                                                 usecols=[b + aa],
                                                                                                 index_col=0)

                                                response_codes_per_second_data_tolist = response_codes_per_second_data.index.tolist()

                                                response_codes_per_second_data_list = ["" if str(x) == "nan" else x for
                                                                                       x in
                                                                                       response_codes_per_second_data_tolist]

                                                series_dict['data'] = response_codes_per_second_data_list

                                                series_data.append(series_dict)

                                                # api名称
                                                legend['data'].append(line[b + aa])

                                                # 获取横坐标
                                                if ENV_PROFILE == "SERVER":
                                                    elapsed_time = pd.read_csv(per_second, encoding='utf-8',
                                                                               usecols=['Elapsed time'],
                                                                               index_col=0).index.tolist()

                                                elif ENV_PROFILE == "1":
                                                    elapsed_time = pd.read_csv(per_second, encoding='gb18030',
                                                                               usecols=['Elapsed time'],
                                                                               index_col=0).index.tolist()
                                                xAxis['data'] = elapsed_time

                                performance_script = PerformanceScript.objects.get(
                                    id=performance_report.performance_script_id)
                                if str(performance_script.loop_count_forever) == 'true':
                                    pressure_test_content = (
                                            '每秒执行' + performance_script.performance_threads + "线程, 持续时间：" + performance_script.performance_duration + "秒")
                                else:
                                    pressure_test_content = (
                                                '每秒执行' + performance_script.performance_threads + "线程")

                                performance_report.pressure_test_content = pressure_test_content
                                performance_report.save()

                                if performance_report.pressure_test_content is None or "":
                                    chart = ""
                                else:
                                    chart = performance_report.pressure_test_content

                                title['text'] = "响应时间随时间变化-" + chart

                                per = {
                                    "title": title,
                                    "tooltip": tooltip,
                                    "legend": legend,
                                    "grid": grid,
                                    "toolbox": toolbox,
                                    "xAxis": xAxis,
                                    "yAxis": yAxis,
                                    "series": series_data

                                }
                                report_dict['response_time_varies_over_time'] = per

                        my_file = Path(dirPath)
                        if my_file.is_file():
                            # 指定的文件存在
                            with open(dirPath, 'r') as csvFile:
                                reader = csv.reader(csvFile)
                                for line in reader:
                                    if reader.line_num == 1:
                                        continue
                                    performance_script_report_dict = {
                                        "test_report_name": performance_report.performance_report_name,
                                        "pressure_test_content": performance_report.pressure_test_content,
                                        "requests_label": line[0],
                                        "samples": line[1],
                                        "api_average": line[2],
                                        "api_median": line[3],
                                        "api_90": line[4],
                                        "api_95": line[5],
                                        "api_99": line[6],
                                        "api_min": line[7],
                                        "api_max": line[8],
                                        "api_error": line[9],
                                        "api_transactions": line[10],
                                        "api_received": line[11],
                                    }
                                    report_list.append(performance_script_report_dict)
                                    report_dict['report_list'] = report_list

                            performance_script_report_list.append(report_dict)

                        else:

                            ENV_PROFILE = os.getenv("ENV")
                            if ENV_PROFILE == "SERVER":
                                CMDRUNNER = '$CMDRUNNER'
                            elif ENV_PROFILE == "1":
                                CMDRUNNER = os.getenv('CmdRunner')
                            else:
                                CMDRUNNER = '$CMDRUNNER'

                            for performance_report in performance_reports:
                                jmeter_aggregate_report_csv = settings.JMETER_REPORT + '/' + str(
                                    performance_report.performance_report_name) + '/' + str(
                                    performance_report.performance_report_name) + '-aggregate' + '.csv'

                                # 聚合报告
                                jmeter_aggregate_report = 'java -jar ' + CMDRUNNER + ' --tool Reporter --generate-csv ' + jmeter_aggregate_report_csv + ' --input-jtl ' + settings.JMETER_REPORT + "/" + str(
                                    performance_report.performance_report_name) + "/" + str(
                                    performance_report.performance_report_name) + ".jtl" + ' --plugin-type AggregateReport'

                                os.system(jmeter_aggregate_report)
                                performance_script = PerformanceScript.objects.get(
                                    id=performance_report.performance_script_id)

                                if str(performance_script.loop_count_forever) == 'true':
                                    pressure_test_content = (
                                            '每秒执行' + performance_script.performance_threads + "线程, 持续时间：" + performance_script.performance_duration + "秒")
                                else:
                                    pressure_test_content = (
                                                '每秒执行' + performance_script.performance_threads + "线程")

                                performance_report.pressure_test_content = pressure_test_content
                                performance_report.save()
                                with open(dirPath, 'r') as csvFile:
                                    reader = csv.reader(csvFile)
                                    for line in reader:
                                        if reader.line_num == 1:
                                            continue
                                        performance_script_report_dict = {
                                            "test_report_name": performance_report.performance_report_name,
                                            "pressure_test_content": performance_report.pressure_test_content,
                                            "requests_label": line[0],
                                            "samples": line[1],
                                            "api_average": line[2],
                                            "api_median": line[3],
                                            "api_90": line[4],
                                            "api_95": line[5],
                                            "api_99": line[6],
                                            "api_min": line[7],
                                            "api_max": line[8],
                                            "api_error": line[9],
                                            "api_transactions": line[10],
                                            "api_received": line[11],
                                        }
                                        report_list.append(performance_script_report_dict)
                                        report_dict['report_list'] = report_list
                            performance_script_report_list.append(report_dict)

        return response_success(performance_script_report_list)

    def put(self, request, *args, **kwargs):
        """
        刷新测试报告数据 只可运行一次 5.13之后弃用
        :param request:
        :param args:
        :param kwargs:
        :return:
        """
        TaskThread22(1).run()

        return response_success()


class PerformanceScriptReportPage(View):
    """
    性能测试报告页面获取
    """

    def get(self, request, performance_report_id, *args, **kwargs):

        performance_script_report_list = []
        ENV_PROFILE = os.getenv("ENV")
        performance_reports = PerformanceReport.objects.filter(id=performance_report_id)
        for performance_report in performance_reports:
            dir_jmeter = settings.JMETER_REPORT
            dir_list = os.listdir(dir_jmeter)
            for report in dir_list:
                if report == str(performance_report.performance_report_name):
                    dirPath = dir_jmeter + '/' + report + '/' + report + '-aggregate.csv'
                    dirResponseCodesPerSecond = dir_jmeter + '/' + report + '/' + report + '-response_codes_per_second.csv'
                    jmeter_jtl = dir_jmeter + '/' + report + '/' + report + '.jtl'
                    report_dict = {}
                    report_list = []

                    # 图表标题
                    title = {}

                    tooltip = {
                                  "trigger": "axis"
                              },

                    toolbox = {
                        "feature": {
                            "saveAsImage": {}
                        }
                    }

                    # 获取api名称
                    legend = {
                        "data": [],
                        "show": bool(True),
                        "top": "6%"
                    }

                    # 获取横坐标
                    xAxis = {
                        "type": 'category'
                    }

                    # 纵坐标
                    yAxis = {
                        "type": "value"
                    }

                    grid = {
                               "left": '3%',
                               "right": '4%',
                               "bottom": '3%',
                               "containLabel": 'true'
                           },

                    # api组合数据
                    series_data = []

                    per_second = Path(dirResponseCodesPerSecond)
                    if per_second.is_file():
                        with open(per_second, 'r') as csvFile:
                            reader_per_second = csv.reader(csvFile)
                            for line in reader_per_second:
                                b = 1
                                if reader_per_second.line_num == 1:
                                    for aa in range(len(line) - 1):
                                        series_dict = {
                                            "name": line[b + aa],
                                            "type": 'line',
                                            'connectNulls': bool(True)
                                        }

                                        # 获取series数据
                                        if ENV_PROFILE == "SERVER":
                                            response_codes_per_second_data = pd.read_csv(per_second,
                                                                                         encoding="utf-8",
                                                                                         usecols=[b + aa],
                                                                                         index_col=0)
                                        elif ENV_PROFILE == "1":
                                            response_codes_per_second_data = pd.read_csv(per_second,
                                                                                         encoding="gb18030",
                                                                                         usecols=[b + aa],
                                                                                         index_col=0)
                                        else:
                                            response_codes_per_second_data = pd.read_csv(per_second,
                                                                                         encoding="utf-8",
                                                                                         usecols=[b + aa],
                                                                                         index_col=0)

                                        response_codes_per_second_data_tolist = response_codes_per_second_data.index.tolist()

                                        response_codes_per_second_data_list = ["" if str(x) == "nan" else x for x in
                                                                               response_codes_per_second_data_tolist]

                                        series_dict['data'] = response_codes_per_second_data_list

                                        series_data.append(series_dict)

                                        # api名称
                                        legend['data'].append(line[b + aa])

                                        # 获取横坐标
                                        if ENV_PROFILE == "SERVER":
                                            elapsed_time = pd.read_csv(per_second, encoding="utf-8",
                                                                       usecols=['Elapsed time'],
                                                                       index_col=0).index.tolist()

                                        elif ENV_PROFILE == "1":
                                            elapsed_time = pd.read_csv(per_second, encoding="gb18030",
                                                                       usecols=['Elapsed time'],
                                                                       index_col=0).index.tolist()
                                        else:
                                            elapsed_time = pd.read_csv(per_second, encoding="utf-8",
                                                                       usecols=['Elapsed time'],
                                                                       index_col=0).index.tolist()

                                        xAxis['data'] = elapsed_time

                        if performance_report.pressure_test_content is None or "":
                            chart = ""
                        else:
                            chart = performance_report.pressure_test_content

                        title['text'] = "响应时间随时间变化-" + chart
                        per = {
                            "title": title,
                            "tooltip": tooltip,
                            "legend": legend,
                            "grid": grid,
                            "toolbox": toolbox,
                            "xAxis": xAxis,
                            "yAxis": yAxis,
                            "series": series_data

                        }
                        report_dict['response_time_varies_over_time'] = per
                        jtl_error_list = []
                        report_error = PerformanceReportError.objects.filter(
                            performance_report_id=performance_report.id)
                        for report_error_jtl in report_error:
                            jtl_error_dict = {
                                "jtl_error": str(report_error_jtl.performance_report_error_name)
                            }
                            jtl_error_list.append(jtl_error_dict)
                        report_dict['jtl_error'] = jtl_error_list

                        # # 解析jtl异常问题
                        # df = pd.read_csv(jmeter_jtl)
                        # jtl_error_list = []
                        # for jtl in df.values.tolist():
                        #     if jtl[3] != 200:
                        #         jtl_error_dict = {
                        #             "jtl_error": str(jtl[2]) + " " + str(jtl[3]) + jtl[4]
                        #         }
                        #         jtl_error_list.append(jtl_error_dict)
                        #         run_function = lambda x, y: x if y in x else x + [y]
                        #         jtl_error = reduce(run_function, [[], ] + jtl_error_list)
                        #         report_dict['jtl_error'] = jtl_error
                        #     else:
                        #         jtl_error_dict = {
                        #             "jtl_error": ""
                        #         }
                        #         jtl_error_list.append(jtl_error_dict)
                        #         run_function = lambda x, y: x if y in x else x + [y]
                        #         jtl_error = reduce(run_function, [[], ] + jtl_error_list)
                        #         report_dict['jtl_error'] = jtl_error

                    else:

                        jtl_error_list = []
                        report_error = PerformanceReportError.objects.filter(
                            performance_report_id=performance_report.id)
                        for report_error_jtl in report_error:
                            jtl_error_dict = {
                                "jtl_error": str(report_error_jtl.performance_report_error_name)
                            }
                            jtl_error_list.append(jtl_error_dict)
                        report_dict['jtl_error'] = jtl_error_list
                        # # 解析jtl异常问题
                        # df = pd.read_csv(jmeter_jtl)
                        # jtl_error_list = []
                        # for jtl in df.values.tolist():
                        #     if jtl[3] != 200:
                        #         jtl_error_dict = {
                        #             "jtl_error": str(jtl[2]) + " " + str(jtl[3]) + jtl[4]
                        #         }
                        #         jtl_error_list.append(jtl_error_dict)
                        #         run_function = lambda x, y: x if y in x else x + [y]
                        #         jtl_error = reduce(run_function, [[], ] + jtl_error_list)
                        #         report_dict['jtl_error'] = jtl_error
                        #     else:
                        #         jtl_error_dict = {
                        #             "jtl_error": ""
                        #         }
                        #         jtl_error_list.append(jtl_error_dict)
                        #         run_function = lambda x, y: x if y in x else x + [y]
                        #         jtl_error = reduce(run_function, [[], ] + jtl_error_list)
                        #         report_dict['jtl_error'] = jtl_error

                        ENV_PROFILE = os.getenv("ENV")
                        if ENV_PROFILE == "SERVER":
                            CMDRUNNER = '$CMDRUNNER'
                        elif ENV_PROFILE == "1":
                            CMDRUNNER = os.getenv('CmdRunner')
                        else:
                            CMDRUNNER = '$CMDRUNNER'

                        for performance_report in performance_reports:
                            # 响应时间随时间变化曲线
                            response_codes_per_second_report = 'java -jar ' + CMDRUNNER + ' --tool Reporter --generate-csv ' + dirResponseCodesPerSecond + ' --input-jtl ' + settings.JMETER_REPORT + "/" + str(
                                performance_report.performance_report_name) + "/" + str(
                                performance_report.performance_report_name) + ".jtl" + ' --plugin-type ResponseTimesOverTime'

                            os.system(response_codes_per_second_report)
                            with open(per_second, 'r') as csvFile:
                                reader_per_second = csv.reader(csvFile)
                                for line in reader_per_second:
                                    b = 1
                                    if reader_per_second.line_num == 1:
                                        for aa in range(len(line) - 1):
                                            series_dict = {
                                                "name": line[b + aa],
                                                "type": 'line',
                                                'connectNulls': bool(True)
                                            }

                                            # 获取series数据
                                            if ENV_PROFILE == "SERVER":
                                                response_codes_per_second_data = pd.read_csv(per_second,
                                                                                             encoding='utf-8',
                                                                                             usecols=[b + aa],
                                                                                             index_col=0)

                                            elif ENV_PROFILE == "1":
                                                response_codes_per_second_data = pd.read_csv(per_second,
                                                                                             encoding='gb18030',
                                                                                             usecols=[b + aa],
                                                                                             index_col=0)

                                            response_codes_per_second_data_tolist = response_codes_per_second_data.index.tolist()

                                            response_codes_per_second_data_list = ["" if str(x) == "nan" else x for
                                                                                   x in
                                                                                   response_codes_per_second_data_tolist]

                                            series_dict['data'] = response_codes_per_second_data_list

                                            series_data.append(series_dict)

                                            # api名称
                                            legend['data'].append(line[b + aa])

                                            # 获取横坐标
                                            if ENV_PROFILE == "SERVER":
                                                elapsed_time = pd.read_csv(per_second, encoding='utf-8',
                                                                           usecols=['Elapsed time'],
                                                                           index_col=0).index.tolist()

                                            elif ENV_PROFILE == "1":
                                                elapsed_time = pd.read_csv(per_second, encoding='gb18030',
                                                                           usecols=['Elapsed time'],
                                                                           index_col=0).index.tolist()
                                            xAxis['data'] = elapsed_time

                            performance_script = PerformanceScript.objects.get(
                                id=performance_report.performance_script_id)
                            if str(performance_script.loop_count_forever) == 'true':
                                pressure_test_content = (
                                        '每秒执行' + performance_script.performance_threads + "线程, 持续时间：" + performance_script.performance_duration + "秒")
                            else:
                                pressure_test_content = ('每秒执行' + performance_script.performance_threads + "线程")

                            performance_report.pressure_test_content = pressure_test_content
                            performance_report.save()

                            if performance_report.pressure_test_content is None or "":
                                chart = ""
                            else:
                                chart = performance_report.pressure_test_content

                            title['text'] = "响应时间随时间变化-" + chart

                            per = {
                                "title": title,
                                "tooltip": tooltip,
                                "legend": legend,
                                "grid": grid,
                                "toolbox": toolbox,
                                "xAxis": xAxis,
                                "yAxis": yAxis,
                                "series": series_data

                            }
                            report_dict['response_time_varies_over_time'] = per

                    my_file = Path(dirPath)
                    if my_file.is_file():
                        # 指定的文件存在
                        with open(dirPath, 'r') as csvFile:
                            reader = csv.reader(csvFile)
                            for line in reader:
                                if reader.line_num == 1:
                                    continue
                                performance_script_report_dict = {
                                    "test_report_name": performance_report.performance_report_name,
                                    "pressure_test_content": performance_report.pressure_test_content,
                                    "requests_label": line[0],
                                    "samples": line[1],
                                    "api_average": line[2],
                                    "api_median": line[3],
                                    "api_90": line[4],
                                    "api_95": line[5],
                                    "api_99": line[6],
                                    "api_min": line[7],
                                    "api_max": line[8],
                                    "api_error": line[9],
                                    "api_transactions": float(line[10]),
                                    "api_received": float(line[11]),
                                }
                                report_list.append(performance_script_report_dict)
                                report_dict['report_list'] = report_list
                        performance_script_report_list.append(report_dict)

                    else:

                        ENV_PROFILE = os.getenv("ENV")
                        if ENV_PROFILE == "SERVER":
                            CMDRUNNER = '$CMDRUNNER'
                        elif ENV_PROFILE == "1":
                            CMDRUNNER = os.getenv('CmdRunner')
                        else:
                            CMDRUNNER = '$CMDRUNNER'

                        for performance_report in performance_reports:
                            jmeter_aggregate_report_csv = settings.JMETER_REPORT + '/' + str(
                                performance_report.performance_report_name) + '/' + str(
                                performance_report.performance_report_name) + '-aggregate' + '.csv'

                            # 聚合报告
                            jmeter_aggregate_report = 'java -jar ' + CMDRUNNER + ' --tool Reporter --generate-csv ' + jmeter_aggregate_report_csv + ' --input-jtl ' + settings.JMETER_REPORT + "/" + str(
                                performance_report.performance_report_name) + "/" + str(
                                performance_report.performance_report_name) + ".jtl" + ' --plugin-type AggregateReport'

                            os.system(jmeter_aggregate_report)
                            performance_script = PerformanceScript.objects.get(
                                id=performance_report.performance_script_id)

                            if str(performance_script.loop_count_forever) == 'true':
                                pressure_test_content = (
                                        '每秒执行' + performance_script.performance_threads + "线程, 持续时间：" + performance_script.performance_duration + "秒")
                            else:
                                pressure_test_content = ('每秒执行' + performance_script.performance_threads + "线程")

                            performance_report.pressure_test_content = pressure_test_content
                            performance_report.save()
                            with open(dirPath, 'r') as csvFile:
                                reader = csv.reader(csvFile)
                                for line in reader:
                                    if reader.line_num == 1:
                                        continue
                                    performance_script_report_dict = {
                                        "test_report_name": performance_report.performance_report_name,
                                        "pressure_test_content": performance_report.pressure_test_content,
                                        "requests_label": line[0],
                                        "samples": line[1],
                                        "api_average": line[2],
                                        "api_median": line[3],
                                        "api_90": line[4],
                                        "api_95": line[5],
                                        "api_99": line[6],
                                        "api_min": line[7],
                                        "api_max": line[8],
                                        "api_error": line[9],
                                        "api_transactions": float(line[10]),
                                        "api_received": float(line[11]),
                                    }
                                    report_list.append(performance_script_report_dict)
                                    report_dict['report_list'] = report_list
                            performance_script_report_list.append(report_dict)

        return response_success(performance_script_report_list)
