# -*- coding: utf-8 -*-
# @Time : 2022/7/5 11:22
# @Author : wangyinghao
# @Site : 
# @File : api_interfaces_case.py
# @Software: PyCharm
from django.db import models
from automated_main.models.api_automation.api_environment import APIEnvironment
from automated_main.models.api_automation.api_database import APIDatabase
from automated_main.models.api_automation.api_management import ApiManagement


class ApiInterfacesCase(models.Model):
    """
    接口测试用例
    """
    api_interfaces_case_name = models.CharField("接口测试用例名称", max_length=200, null=False)
    api_documentation = models.TextField("API接口文档地址", max_length=5000, null=True)
    api_management = models.ForeignKey(ApiManagement, on_delete=models.CASCADE)
    api_environment = models.ForeignKey(APIEnvironment, on_delete=models.CASCADE)
    api_method = models.IntegerField("请求方法", null=False)  # 1:get 2.post 3:put 4:delete
    api_url = models.TextField("API请求地址", null=False)
    # 1：form-data 2: json 3:x-www-form-urlencoded
    api_parameter_types = models.IntegerField("参数类型", null=False)
    api_headers = models.TextField("请求头", null=False)
    api_parameter_body = models.TextField("参数内容", null=False)
    api_assert_type = models.IntegerField("断言类型", null=False)  # 1：包含contains 2: 匹配mathches 3:数据库校验 4:code状态码
    dataBase = models.ForeignKey(APIDatabase, on_delete=models.CASCADE, blank=True, null=True)
    database_sql = models.TextField("数据库SQL", max_length=8000, null=True, blank=True)
    api_assert_text = models.TextField("断言结果", null=False)
    update_time = models.DateTimeField(auto_now_add=True)
    create_time = models.DateTimeField("创建时间", auto_now_add=True)

    def __str__(self):
        return self.api_interfaces_case_name


class ApiInterfacesParameterExtraction(models.Model):
    """
    Api提取变量表
    """
    api_test_case = models.ForeignKey(ApiInterfacesCase, on_delete=models.CASCADE)
    api_variable_results = models.TextField("变量提取结果", max_length=5000, null=True)
    api_value_variable = models.TextField("提取变量", max_length=5000, null=True)
    api_key_variable = models.TextField("关键字变量名称", max_length=5000, null=True)

    def __str__(self):
        return self.api_key_variable


class ApiInterfacesParameterData(models.Model):
    """
    Parameter参数
    """
    api_test_case = models.ForeignKey(ApiInterfacesCase, on_delete=models.CASCADE)
    api_parameter_name = models.CharField("参数名称", max_length=500, null=True)
    api_must_parameter = models.TextField("必填", max_length=50, null=True)
    api_parameter_value = models.TextField("参数值", max_length=5000, null=True)
    api_field_describe = models.TextField("字段描述", max_length=5000, null=True)

    def __str__(self):
        return self.api_parameter_name
