module.exports = {
  root: true,
  env: {
    node: true,
    browser: true,
  },
  extends: ["eslint:recommended", "plugin:prettier/recommended"],
  parserOptions: {
    parser: "babel-eslint"
  },
  // TODO 配置强制使用模板字符串
  rules: {
    'prettier/prettier': 'error',
    'no-empty': ["error", { "allowEmptyCatch": true }],
    'arrow-parens': 'off', // allow paren-less arrow functions
    'generator-star-spacing': 'off', // allow async-await
    'no-unused-vars': 'error', // disabled no ununsed var
    'no-debugger': process.env.NODE_ENV === 'production' ? 'error' : 'off', // no use debugger in production
    'indent': [2, 2, { SwitchCase: 1 }], // 2 space for tab for perttier
    'space-before-function-paren': ['error', 'never'], // no space in function name for perttier
  }
};
