import { isAndroid, isIOS, isWechat } from './utils';
import localStorage from './localStorage';

function getURLSearchParams(json) {
  if (!json) return '';
  const dataArray = Object.keys(json).map(key => {
    if (json[key] === undefined) return '';
    return encodeURIComponent(key) + '=' + encodeURIComponent(json[key]);
  });
  return dataArray.filter(item => item !== undefined && item !== null).join('&');
}

function getVccChannel() {
  return isWechat
    ? localStorage.get('vccChannel') || ''
    : (isAndroid ? '159905' : isIOS ? '159904' : localStorage.get('vccChannel')) || '';
}
export default function strategyModes(toastFn = () => {}) {
  return {
    service: {
      response(res) {
        const { data, config } = res;
        // api需要返回原始响应
        const returnRawData = config.rawData;
        if (returnRawData) return [data, null];

        const success =
          (data.code === 0 && data.business_code === 0) ||
          (data.code === '0000' && data.businessCode === '0000');
        // 业务完成，返回有效载荷
        if (success) {
          return [data.data, null];
        }
        // 接下来处理异常业务
        const msg = data.msg || '服务异常';

        if (!config.hideToast || !data.noAlert) {
          toastFn(msg);
        }
        // 给用户提示信息，明确发生错误
        // 请求参数和响应数据都可以控制不提示
        let error = new Error(msg);
        error.response = data;
        console.error(error);
        // 业务代码可以根据response进行再处理
        return [null, error];
      },
      request(cfg) {
        const { method, hideVccChannel } = cfg;
        cfg.headers['X-Auth-Token'] = localStorage.get('vccToken') || '';
        if (cfg.customHeader) {
          Object.assign(cfg.headers, cfg.customHeader);
        }
        if (cfg.creditToken) {
          cfg.headers['X-Auth-Token'] = localStorage.get('creditToken');
        }
        if (!hideVccChannel) {
          cfg.headers['vccChannel'] = getVccChannel();
        }
        if (method === 'post' && cfg.emulateJSON) {
          cfg.headers['Content-Type'] = 'application/x-www-form-urlencoded';
          cfg.data = getURLSearchParams(cfg.data);
        }
        return cfg;
      }
    }
  };

};
