import babel from '@rollup/plugin-babel';
import eslint from '@rollup/plugin-eslint';
import commonjs from '@rollup/plugin-commonjs';
import { terser } from 'rollup-plugin-terser';
import visualizer from 'rollup-plugin-visualizer';

import pkg from './package.json';

export default {
  input: 'src/index.js',
  external: ['webpack-log'],
  output: [
    {
      file: pkg.main,
      format: 'cjs',
    },
  ],
  plugins: [
    babel({
      exclude: 'node_modules/**',
      presets: [ '@babel/preset-env' ],
    }),
    eslint({
      throwOnError: true,
      include: ['src/**/*.ts'],
      exclude: ['node_modules/**', 'lib/**'],
    }),
    commonjs(),
    terser(),
    visualizer(),
  ],
};
