# webpack-cos-cdn-upload-plugin

webpack静态资源上传腾讯云插件

## 如何打包

1. 全局安装rollup
2. npm run build
3. 更新版本号，npm publish 到私服

## 如何使用

```js
// webpack config 

const WebpackCosCdnUploadPlugin = require('webpack-cos-cdn-upload-plugin');

plugins: [
  new WebpackCosCdnUploadPlugin()
]

```

## Props

### options

对象中包含以下参数，如果不设置会走默认配置

| 名称           | 说明                                                         | 默认值                                          |
| -------------- | ------------------------------------------------------------ | ----------------------------------------------- |
| SecretId       | 腾讯云SecretId                                               | `AKIDVlxtVqOK9i0wc0m0e7C5saATZnl2xvUx`          |
| SecretKey      | 腾讯云SecretKey                                              | `NWQ3VlmWeFtIQHrDI6F9oCheMq41lGVV`              |
| ImageBucket    | 图片资源存放Bucket                                           | `image-1258270469`                              |
| MiscBucket     | 逻辑资源存放Bucket                                           | `misc-1258270469`                               |
| ImageHost      | 图片资源访问域名                                             | `https://img.lkbang.net`                        |
| MiscHost       | 逻辑资源访问域名                                             | `https://misc.lkbang.net`                       |
| AppId          | 腾讯云Bucket AppId                                           | `1258270469`                                    |
| Region         | 腾讯云Bucket 存放区域                                        | `ap-beijing`                                    |
| UseSTS         | 是否使用临时授权，默认不使用，**临时授权有访问频率限制**     | `false`                                         |
| ProjectName    | 自定义项目名称，会影响资源访问地址，默认以打包目录名称的md5 hash前8位作为项目名称 | `''`                                            |
| TestEnvSkip    | 测试环境是否上传，默认不上传                                 | `true`                                          |
| PluginName     | 插件名称                                                     | `webpack-cos-cdn-upload-plugin`                 |
| PluginNameAbbr | 插件名称缩写，输出用                                         | `COS2CDN`                                       |
| MiscExtMap     | 逻辑资源扩展名名单，可将非逻辑资源扩展名，添加到此处         | `[ '.css', '.js', '.json', '.mainfest' ]`       |
| FontsExtMap    | 字体资源扩展名名单，字体文件单独存放                         | `[ '.ttf', '.woff', '.woff2', '.otf', '.svg' ]` |
| IgnoreExtMap   | 不上传资源扩展名名单                                         | `[ '.map' ]`                                    |

## TODO

- [ ] upload方法可扩展
