# @qg/ui-request

axios策略请求封装

## 这是个啥

axios二次封装npm包，增强。

## 为什么会存在这个包

平时使用axios请求接口，针对不同后端提供的接口，可能返回的数据格式不同，同时处理逻辑也不同，会造成编写不同的逻辑代码。

这个包把axios公共的请求逻辑和拦截器进行整合，并暴露出业务逻辑处理配置，减少代码，使axios更好配置。

## 如何使用

插件声明后，会直接返回axios实例，直接调用axios自带方法即可。

```javascript
import HttpRequest from '@qg/ui-request';
import { Toast } from '@qg/cherry-ui';
import store from '@/store';
const http = new HttpRequest(
  {},
  {},
  function(msg) {
    Toast(msg);
  },
  function(loadingState) {
    store.dispatch('change_loading', loadingState);
  }
);

http.get(`${talosHost}/vcc/xyqb/recommend/goods-list`, {
      customHeader: {
        scDeviceId: await saDeviceId()
      }
    });
  }
```



## Props

| 名称      | 类型       | 说明                                  | 默认值                                                       |
| --------- | ---------- | ------------------------------------- | ------------------------------------------------------------ |
| strategy  | _Object_   | 业务配置策略，默认值及格式见config.js | http://git.quantgroup.cn/zhiwei.guo/ui-request/blob/master/src/config.js |
| config    | _Object_   | axios初始配置                         | `{timeout: 15000}`                                           |
| toastFn   | _Function_ | 提示方法回调                          |                                                              |
| loadingFn | _Function_ | loading方法回调，返回loading状态      |                                                              |

## Method

#### setStrategy

- **参数：**

  - `{Object} [strategy] {} ` 
  - `{Boolean} [cover] false`

- **用法：**

  使用该方法将更新当前的请求策略， `cover`为`true`时，会覆盖掉原有的配置

  ```javascript
  http.setStrategy({ service: {} });
  ```

  

#### setLoadingFn

- **参数：**

  - `{Function} [fn]`

- **用法：**

  使用该方法将更新当前的loading控制回调

  ```javascript
  http.setLoadingFn(() => {});
  ```

  

#### setToastFn

- **参数：**

  - `{Function} [fn]`

- **用法：**

  使用该方法将更新当前的loading控制回调

  ```javascript
  http.setToastFn(() => {});
  ```

  