import { isAndroid, isIOS, isWechat } from './utils';
import localStorage from './localStorage';
import Bridge from '@qg/js-bridge';
import {isApp} from './utils'

function getURLSearchParams(json) {
  if (!json) return '';
  const dataArray = Object.keys(json).map(key => {
    if (json[key] === undefined) return '';
    return encodeURIComponent(key) + '=' + encodeURIComponent(json[key]);
  });
  return dataArray.filter(item => item !== undefined && item !== null).join('&');
}

function getVccChannel(channelKey = 'vccChannel') {
  if(channelKey === 'sonVccChannel') {
    return localStorage.get(channelKey) || '';
  }
  return isWechat
    ? localStorage.get(channelKey) || ''
    : (isAndroid ? '159905' : isIOS ? '159904' : localStorage.get(channelKey)) || '';
}
export default function strategyModes(toastFn = () => {}) {
  return {
    service: {
      response(res) {
        const { data, config } = res;
        // api需要返回原始响应
        const returnRawData = config.rawData;
        if (returnRawData) return [data, null];

        const success =
          (data.code === 0 && data.business_code === 0) ||
          (data.code === '0000' && data.businessCode === '0000');
        // 业务完成，返回有效载荷
        if (success) {
          return [data.data, null];
        }
        // 接下来处理异常业务
        const msg = data.msg || '服务异常';

        if (!config.hideToast || ('noAlert' in data && !data.noAlert)) {
          toastFn(msg);
        }
        // 给用户提示信息，明确发生错误
        // 请求参数和响应数据都可以控制不提示
        let error = new Error(msg);
        error.response = data;
        if((error?.response?.businessCode==='6049' || error?.response?.businessCode==='401')&&isApp){
          const nativeBridge = new Bridge();
          window.xyqbNativeEvent = function(res) {
            const json = typeof res === 'string' ? JSON.parse(res) : res;
            if (json.event === 'getTokenSuccess') {
              const appData = json.data || {};
              if (appData && appData.token) {
                localStorage.set('vccToken', appData.token);
              }
            }
          };
          nativeBridge.getToken();
        }
        console.error(error);
        // 业务代码可以根据response进行再处理
        return [null, error];
      },
      request(cfg) {
        const { method, hideVccChannel } = cfg;
        cfg.headers['X-Auth-Token'] = localStorage.get('vccToken') || '';
        cfg.headers['qg-tenant-id'] = localStorage.get('tenantId') || '';
        if (cfg.customHeader) {
          Object.assign(cfg.headers, cfg.customHeader);
        }
        if (cfg.creditToken) {
          cfg.headers['X-Auth-Token'] = localStorage.get('creditToken');
        }
        if (!hideVccChannel) {
          cfg.headers['vccChannel'] = getVccChannel();
          cfg.headers['sonVccChannel'] = getVccChannel('sonVccChannel');
        }
        if (method === 'post' && cfg.emulateJSON) {
          cfg.headers['Content-Type'] = 'application/x-www-form-urlencoded';
          cfg.data = getURLSearchParams(cfg.data);
        }
        return cfg;
      }
    }
  };

};
