# 系统开发sdk

提供了如下功能

1. 操作cookie

2. 操作localStorage

3. http请求

4. bus

### 发布方式
```
npm publish --registry http://172.16.3.15:4873
```


### http使用
```
// main.js中配置http实例
import {http} from './sys-sdk'

Object.assign(http._extend, {
  loginUrl: `${config}/user/toLogin`, // token过期后的登录地址
  notice: iView.Notice // 发生错误时提示信息的组件
  refresTokenHost: `http://backstms.q-gp.com` // 刷新tokenhost
})

// xxx.service.js
import {http as axios} from 'sys-sdk'

axios.get(`${apiHost}/userManage/authority`)
axios.post(`${apiHost}/user/info`, {token: token}

```

##### http默认拦截器
```
// 请求前
if (localStorage.get('token')) {
    config.headers['x-auth-token'] = localStorage.get('token') || ''
}
config.headers['x-auth-system'] = Cookies.get('op.system') || ''
config.headers['X-Requested-With'] = 'XMLHttpRequest'

// 响应
if (response.status < 200 || response.status > 300 || response.data.code !== '0000') {
    instance._extend.notice && instance._extend.notice.error({
      desc: response.data && response.data.msg || '后端服务异常'
    })

    return Promise.reject(response)
}

return response.data

// 错误响应
if (error.response) {
    switch (error.response.status && instance._extend.loginUrl) {
      case 401:
        let href = window.location.href.replace(/\?token=[a-z0-9\-A-Z]+/g, '')
        window.location.href = instance._extend.loginUrl + '?url=' + window.btoa(href)
        break
    }
}
return Promise.reject(error)

```

##### http删除默认拦截器

```
// main.js
import {http} from 'sys-sdk'

// 不使用默认请求拦截器
http.interceptors.request.eject(0)

// 不使用默认响应拦截器
axios.interceptors.response.eject(0)

```

### bus 使用
```
// main.js
import {Bus} from 'sys-sdk'

// 会增加has-role指令，控制页面中具体元素的展示
Bus.mixinVue(Vue)

// Home.vue
// 获取用户信息后, 初始化
Bus.init(res)

init = function (user) {
  bus.user = user
  bus.roles = user.roles.map((role) => {
    return role.key
  })
}

```