import Vue from 'vue'

const bus = new Vue()

bus.init = function (user) {
  bus.user = user
  bus.roles = user.roles.map((role) => {
    return role.key
  })
}

bus.initCurNav = function (user) {
  bus.curNav = user
}

/**
 * @param role
 * Example:
 *  roleA|roleB  有角色A或者角色B
 *  roleA&roleB  同时有角色A和角色B
 */
bus.hasRole = function (role) {
  return bus.roles && bus.roles.includes(role)
}

// 扩展root vue
bus.mixinVue = function (anotherVue) {
  anotherVue.directive('has-role', {
    inserted: function (el, binding, vnode) {
      console.log(el)
      console.log(binding.value)
      console.log(vnode)
      //
      el.style.display = bus.hasRole(binding.value) ? 'initial' : 'none'
    }
  })
}

export default bus
