/**
 * 防抖函数
 * @param {Function} fn 需要防抖的函数
 * @param {Number} interval 防抖时间间隔
 * @param {Boolean} immediate 是否立即执行
 * **/
export function debounce(fn, interval, immediate) {
  let flag = true;
  const time = interval || 1000;
  let timer = null;
  return function() {
    if (!immediate) {
      timer && clearTimeout(timer);
      timer = setTimeout(() => {
        fn.apply(this, arguments);
      }, time);
    } else {
      if (flag) {
        fn.apply(this, arguments);
        flag = false;
        return;
      }
      timer && clearTimeout(timer);
      timer = setTimeout(() => {
        fn.apply(this, arguments);
      }, time);
    }
  };
}