'use strict'

import axios from 'axios'

import localStorage from './localStorage'
import Cookies from './cookies'

const config = {
  timeout: 5000
}
const instance = axios.create(Object.assign({}, config))

// 挂载扩展配置
instance._extend = {}

const requestInterceptor = function (config) {
  if (localStorage.get('token')) {
    config.headers['x-auth-token'] = localStorage.get('token') || ''
  }
  config.headers['x-auth-system'] = Cookies.get('op.system') || ''
  config.headers['X-Requested-With'] = 'XMLHttpRequest'
  return config
}

const responseInterceptor = function (response) {
  if (response.status < 200 || response.status > 300 || response.data.code !== '0000') {
    instance._extend.notice && instance._extend.notice.error({
      desc: response.data && response.data.msg || '后端服务异常'
    })

    return Promise.reject(response)
  }

  return response.data
}

/**
 * 不使用默认拦截器
 *    axios.interceptors.request.eject(0)
 *    axios.interceptors.response.eject(0)
 */
instance.interceptors.request.use(requestInterceptor, (error) => {
  return Promise.reject(error)
})

instance.interceptors.response.use(responseInterceptor, error => {
  if (error.response) {
    switch (error.response.status && instance._extend.loginUrl) {
      case 401:
        let href = window.location.href.replace(/\?token=[a-z0-9\-A-Z]+/g, '')
        window.location.href = instance._extend.loginUrl + '?url=' + window.btoa(href)
        break
    }
  }
  return Promise.reject(error)
})

export default instance
