import localStorage from '../services/localStorage.service'
export default{
  init (router) {
    router.beforeEach((to, form, next) => {
      const token = localStorage.get('token')
      if (to.meta && !to.meta.allowBack && window.history && window.history.pushState) {
        history.pushState(null, null, document.URL)
      }
      if (to.name === 'login') {
        next()
        return
      }
      if (!token) {
        window.location.href = `${window.location.origin}/login`
        return
      }
      next()
    })
  }
}
