import axios from '../services/http.service'
import {
  sapi
} from '../config'
export function getSoulSoother () {
  return axios.get(`${sapi}/api/sysStrategy/getTodaySoul`, {headers: {
    'Content-Type': 'application/json'
  }})
}
export function getlist () {
  return axios.get(`${sapi}/api/sysStrategy/query`, {headers: {
    'Content-Type': 'application/json'
  }})
}
export function addtitlelist (data) {
  return axios.post(`${sapi}/api/strategyObjectives/save`, data, {headers: {
    'Content-Type': 'application/json'
  }})
}
export function delatetitlelist (data) {
  return axios.post(`${sapi}/api/strategyObjectives/delete/${data}`, {headers: {
    'Content-Type': 'application/json'
  }})
}
export function savechildput (data) {
  return axios.post(`${sapi}/api/keyresults/save`, data, {headers: {
    'Content-Type': 'application/json'
  }})
}
// 删除战略步骤
export function delatechildputchlid (data) {
  return axios.post(`${sapi}/api/keyresults/delete/${data}`, {headers: {
    'Content-Type': 'application/json'
  }})
}
// 保存战略大标题
export function savehostTitle (data) {
  return axios.post(`${sapi}/api/sysStrategy/edit`, data, {headers: {
    'Content-Type': 'application/json'
  }})
}
// 排序战略
export function sortstrategy (arr, data) {
  return axios.post(`${sapi}/api/keyresults/${data}/order`, arr, {headers: {
    'Content-Type': 'application/json'
  }})
}
// 查询素材列表
export function getsourcelist (data) {
  return axios.get(`${sapi}/api/material/${data}/list`, {headers: {
    'Content-Type': 'application/json'
  }})
}
// 编辑素材
export function editsourceitem (data) {
  return axios.post(`${sapi}/api/material/save`, data, {headers: {
    'Content-Type': 'application/json'
  }})
}
// 删除素材
export function delatesourceitem (data) {
  return axios.post(`${sapi}/api/material/delete/${data}`, {headers: {
    'Content-Type': 'application/json'
  }})
}
// 查询战略详细列表
export function getdetailList (data) {
  return axios.post(`${sapi}/api/keyresultsDetail/${data}/list`, {headers: {
    'Content-Type': 'application/json'
  }})
}
// 新增或修改战略详情
export function edutListitem (data) {
  return axios.post(`${sapi}/api/keyresultsDetail/save`, data, {headers: {
    'Content-Type': 'application/json'
  }})
}
// 删除战略详情
export function delateListitem (data) {
  return axios.post(`${sapi}/api/keyresultsDetail/delete/${data}`, {headers: {
    'Content-Type': 'application/json'
  }})
}
// 获取钉钉员工列表
export function getname (data) {
  return axios.get(`${sapi}/api/dingdingUser/searchDingDingUserByKey?key=${data}`, {headers: {
    'Content-Type': 'application/json'
  }})
}
// 获取鉴权相关参数配置
export function getconfiglist () {
  return axios.get(`${sapi}/api/dingTalk/getDingTalkConfig`, {headers: {
    'Content-Type': 'application/json'
  }})
}
// 发送钉钉消息
export function sendding (data) {
  return axios.post(`${sapi}/api/dingNotice/send`, data, {headers: {
    'Content-Type': 'application/json'
  }})
}
