import axios from 'axios'
import { Notice } from 'iview'
import localStorage from './localStorage.service'

// window.Promise = require('es6-promise').Promise

const config = {
  timeout: 600000
  // withCredentials: true // 允许携带cookie
}
const instance = axios.create(Object.assign({}, config))
instance._extend = {}

function requestInterceptor (config) {
  config.headers['x-requested-with'] = 'XMLHttpRequest'

  // if (!config.headers['Content-Type']) {
  //   config.headers['Content-Type'] = 'application/x-www-form-urlencoded'
  // }

  if (!config.headers['token']) {
    config.headers['token'] = localStorage.get('token') || ''
  }

  return config
}

function responseInterceptor (response) {
  if (response.status < 200 || response.status > 300) {
    Notice.error({
      title: '请求发生错误',
      desc: response && response.data && (response.data.errorMsg || '请联系系统管理员')
    })
    return Promise.reject(response && response.data)
  }
  // code是0000表示成功
  if (response.status === 200 || response.status === 400) {
    return Promise.resolve(response || null)
  }

  // Notice.error({
  //   title: '',
  //   desc: response.data.errorMsg || response.data.message || '请联系客服'
  // })
  return Promise.reject(response && response.data)
}

/**
 * 不使用默认拦截器
 *    axios.interceptors.request.eject(0)
 *    axios.interceptors.response.eject(0)
 */
instance.interceptors.request.use(requestInterceptor, (error) => {
  return Promise.reject(error)
})

instance.interceptors.response.use(responseInterceptor, error => {
  if (error.response && error.response.status === 401) {
    window.location.href = window.location.origin + '/login'
  }

  if (error.message.indexOf('timeout') !== -1) {
    Notice.error({
      title: '',
      desc: '请求超时'
    })
  }
  // return Promise.reject(error)
})

export default instance
