/**
 * Created by sunxiaoying on 2017/7/21.
 */
import qs from 'qs';
import config from '../../config';
const { baseURI, appApi } = config;

// 显示配置
export default {
  // 新增
  newAddeBanner(params) {
    return http.post(`${appApi}/api/kdsp/app/app-config-push/save`, params);
  },
  // 查询多条
  newGetList(params) {
    return http.post(`${appApi}/api/kdsp/app/app-config-push/list`, params);
  },
  // 编辑/修改
  compileListItem(params) {
    return http.post(`${appApi}/api/kdsp/app/app-config-push/update`, params);
  },
  // 查询单条
  searchOneData(params) {
    return http.post(`${appApi}/api/kdsp/app/app-config-push/find`, qs.stringify(params));
  },
  getPositionList() {
    return http.get(`${baseURI}/config/ad/default-type`);
  },

  getList(params) {
    return http.get(`${baseURI}/config/ad/ad-list/1?${qs.stringify(params)}`);
  },

  getAdvInfo(id) {
    return http.get(`${baseURI}/config/ad/query-ad-detail/${id}/1`);
  },
  enableAdv(id, enable) {
    return http.post(`${baseURI}/config/ad/enable/${id}/${enable}/1`);
  },
  move(sourceId, targetId) {
    return http.post(`${baseURI}/config/ad/move/${sourceId}/${targetId}/1`);
  },
  buoyInfo(state) {
    return http.get(`${baseURI}/config/page/card-buoy-info/${state}`);
  },
  buoySave(params) {
    return http.post(`${baseURI}/config/page/save-card-buoy`, params);
  },
  borrowInfo(state) {
    return http.get(`${baseURI}/config/page/borrowing-info/${state}`);
  },
  borrowSave(params) {
    return http.post(`${baseURI}/config/page/save-borrowing`, qs.stringify(params), {
      headers: {
        'Content-Type': ' application/x-www-form-urlencoded',
      },
    });
  },
  cardTitleInfo(state) {
    return http.get(`${baseURI}/config/page/card-title-info/${state}`);
  },
  cardTitleSave(params) {
    return http.post(`${baseURI}/config/page/save-card-title`, params);
  },
  cardInfo(state) {
    return http.get(`${baseURI}/config/page/card-copy-info/${state}`);
  },
  cardSave(params) {
    return http.post(`${baseURI}/config/page/save-card-copy`, qs.stringify(params), {
      headers: {
        'Content-Type': ' application/x-www-form-urlencoded',
      },
    });
  },
  buttonInfo(state) {
    return http.get(`${baseURI}/config/page/button-info/${state}`);
  },
  buttonSave(params) {
    return http.post(`${baseURI}/config/page/save-button`, qs.stringify(params), {
      headers: {
        'Content-Type': ' application/x-www-form-urlencoded',
      },
    });
  },
  newAdv(params) {
    return http.post(`${baseURI}/config/ad/add-ad/1`, qs.stringify(params));
  },
  detailInfo(state) {
    return http.get(`${baseURI}/config/page/see-detail/${state}`);
  },
  detailSave(params) {
    return http.post(`${baseURI}/config/page/save-see-detail`, qs.stringify(params), {
      headers: {
        'Content-Type': ' application/x-www-form-urlencoded',
      },
    });
  },
  queryConfig(loanState) {
    return http.get(`${baseURI}/config/page/query-config?loanState=${loanState}`);
  },
  addBanner(params) {
    return http.post(`${baseURI}/config/page/add-banner`, qs.stringify(params), {
      headers: {
        'Content-Type': ' application/x-www-form-urlencoded',
      },
    });
  },
  updateBanner(params) {
    params.updateStates = params.displayCode;
    return http.post(`${baseURI}/config/page/update-banner`, qs.stringify(params), {
      headers: {
        'Content-Type': ' application/x-www-form-urlencoded',
      },
    });
  },
  bannerInfo(id, loanState) {
    return http.get(`${baseURI}/config/page/get-banner?id=${id}&loanState=${loanState}`);
  },
  moveBanner(sourceId, targetId, loanState) {
    const params = {
      loanState,
      targetId,
      sourceId,
    };
    return http.post(`${baseURI}/config/page/move-banner`, qs.stringify(params), {
      headers: {
        'Content-Type': ' application/x-www-form-urlencoded',
      },
    });
  },
  enableBanner(id, enable, loanState) {
    const params = {
      id,
      enable,
      loanState,
    };
    return http.post(`${baseURI}/config/page/enable-banner`, qs.stringify(params), {
      headers: {
        'Content-Type': ' application/x-www-form-urlencoded',
      },
    });
  },
  bannerQuery(params) {
    return http.get(`${baseURI}/config/page/banners?enable=${params.enable || ''}&loanState=${params['userState']}`);
  },
  getAdUserStatusList() {
    return http.get(`${baseURI}/config/ad/loan-states`);
  },
};
