export const commodityChannel = [
  {
    id: 1,
    name: '自营',
  },
  {
    id: 2,
    name: '京东开普勒',
  },
  {
    id: 3,
    name: '京东联盟',
  },
  {
    id: 4,
    name: '众联 ',
  },
  {
    id: 5,
    name: '企业购',
  },
  {
    id: 6,
    name: '京东企业购直连',
  },
];
export const formValidate = {
  skuName: {
    required: true,
    message: '请输入商品名称',
    trigger: 'blur',
  },
  marketPrice: {
    required: true,
    message: '请输入正确类型的划线价格',
    trigger: 'blur',
    pattern: /^0\.([1-9]|\d[1-9])$|^[1-9]\d{0,8}\.\d{0,2}$|^[1-9]\d{0,8}$/,
  },
  salePrice: {
    required: true,
    message: '请输入正确类型的销售价格',
    trigger: 'blur',
    pattern: /^0\.([1-9]|\d[1-9])$|^[1-9]\d{0,8}\.\d{0,2}$|^[1-9]\d{0,8}$/,
  },
  imageUrl: {
    required: true,
    message: '请输入商品图片地址',
    trigger: 'blur',
  },
  pushedAt: { required: true, message: '请选择发布时间', trigger: 'change' },
  // offlineAt: { required: true, message: '请选择下架时间', trigger: 'change' },
};
export const ruleValidate = {
  labelName: {
    required: true,
    message: '请输入标签名称',
    trigger: 'blur',
  },
  labelShowName: {
    message: '请输入标签展示名称，英文逗号隔开',
    trigger: 'blur',
  },
  bannerTime: {
    required: true,
    message: '请选择横幅有效期',
    trigger: 'change',
    pattern: /.+/,
  },
  bannerImg: {
    required: true,
    message: '请上传图片',
    trigger: 'change',
    type: 'array',
  },
};
export const tagValidate = {
  labelId: {
    required: true,
    message: '请输入选择已有标签',
    trigger: 'blur',
    type: 'number',
  },
};
export const speciaRuleValidate = {
  discountShow: [
    {
      required: true,
      message: '请输入活动调价策略',
      trigger: 'blur',
    },
    {
      pattern: /^([1-9]|10)$/,
      message: '请输入1～9参数折扣系数,原价请输入10',
      trigger: 'blur',
    },
  ],
  name: {
    required: true,
    message: '请输入专题名称',
    trigger: 'blur',
  },
};
export const goodsStatusMap = {
  1: '未上架',
  2: '审核中',
  3: '已上架',
  4: '我方下架',
  5: '三方下架',
};
export const goodsStatus = [
  {
    id: 1,
    name: '未上架',
  },
  {
    id: 2,
    name: '审核中',
  },
  {
    id: 3,
    name: '已上架',
  },
  {
    id: 4,
    name: '我方下架',
  },
  {
    id: 5,
    name: '三方下架',
  },
];
export const dynamicRules = {
  labelInfoId: {
    required: true,
    message: '请选择模板',
    trigger: 'change',
  },
  goodsCount: {
    required: true,
    message: '请输入正确类型的活动库存',
    trigger: 'blur',
    pattern: /^[0-9]*[1-9][0-9]*$/,
  },
};
export const limitgoodsList = [
  {
    id: 2,
    name: '指定品类',
  },
  {
    id: 1,
    name: '指定标签',
  },
];
