export const actiontags = [
  {
    name: '最近有加购',
    key: 'addShopCar',
  },
  {
    name: '最近无加购',
    key: 'notAddShopCar',
  },
  {
    name: '最近有购买',
    key: 'buy',
  },
  {
    name: '最近无购买',
    key: 'notBuy',
  },
];
export const vcctags = [
  {
    name: '未申请',
    key: 'notApply',
  },
  {
    name: '授信审核中',
    key: 'audit',
  },
  {
    name: '审核被拒',
    key: 'refuse',
  },
  {
    name: '审核成功待激活',
    key: 'unactivated',
  },
  {
    name: '激活成功',
    key: 'activated',
  },
];
export const xjfqtags = [
  {
    name: '未登录',
    key: '1',
  },
  {
    name: '未申请',
    key: '2',
  },
  {
    name: '审核中',
    key: '3',
  },
  {
    name: '审核通过待提现',
    key: '4',
  },
  {
    name: '放款中',
    key: '5',
  },
  {
    name: '放款失败',
    key: '6',
  },
  {
    name: '七日无待还',
    key: '7',
  },
  {
    name: '七日内有待还',
    key: '8',
  },
  {
    name: '已逾期',
    key: '9',
  },
  {
    name: '审核被拒',
    key: '10',
  },
  {
    name: '再来一单',
    key: '11',
  },
  {
    name: '多订单还款中',
    key: '12',
  },
];
export const actiondays = [1, 3, 7, 15, 30, 45, 60, 90, 180];

export const operationType = [
  {
    name: '区间',
    key: 'BETWEEN',
  },
  {
    name: '小于',
    key: 'LT',
  },
  {
    name: '小于等于',
    key: 'LE',
  },
  {
    name: '大于等于',
    key: 'GE',
  },
  {
    name: '大于',
    key: 'GT',
  },
];
export const shopType = [
  {
    name: '累计提交订单',
    key: 'submitOrderTimes',
  },
  {
    name: '累计购买金额',
    key: 'submitOrderAmt',
    suffix: '元',
  },
  {
    name: '有效购买次数',
    key: 'paidOrderTimes',
  },
  {
    name: '有效购买金额',
    key: 'paidOrderAmt',
    suffix: '元',
  },
];
export const amountUsedType = [
  {
    name: '累计额度使用次数',
    key: 'usedQuotaTimes',
  },
  {
    name: '累计额度使用金额',
    key: 'usedQuotaAmt',
    suffix: '元',
  },
];
export const userGroupKey = [
  { key: 'sex', type: 'select' }, // 性别
  { key: 'age', type: 'range' }, // 年龄
  { key: 'houseAddress', type: 'array' }, // 户籍地
  { key: 'ipAddress', type: 'array' }, // ip地址
  { key: 'registerChannel', type: 'array' }, // 注册渠道
  { key: 'addShopCar', type: 'select' }, // 最近有加购
  { key: 'notAddShopCar', type: 'select' }, // 最近无加购
  { key: 'buy', type: 'select' }, // 最近有购买
  { key: 'notBuy', type: 'select' }, // 最近无购买
  { key: 'latestPaidOrderTime', type: 'array' }, // 购买时间
  { key: 'submitOrderTimes', type: 'between' }, // 累计购买次数
  { key: 'submitOrderAmt', type: 'between' }, // 累计购买金额
  { key: 'paidOrderTimes', type: 'between' }, // 有效购买次数
  { key: 'paidOrderAmt', type: 'between' }, // 有效购买金额
  { key: 'notApply' }, // 未申请
  { key: 'audit' }, // 审核中
  { key: 'refuse' }, // 审核拒绝
  { key: 'unactivated' }, // 审核通过未激活
  { key: 'activated' }, // 已激活
  { key: 'usedQuotaTimes', type: 'between' }, // 累计额度使用次数
  { key: 'usedQuotaAmt', type: 'between' }, // 累计额度使用金额
];
export const initForm = handleFormData();
export function isObject(val) {
  return Object.prototype.toString.call(val) === '[object Object]';
}
export function handleFormData(data = {}) {
  const tempObj = {};
  userGroupKey.forEach(keyItem => {
    const { type, key } = keyItem;
    tempObj[key] = {};
    if (data[key]) {
      switch (type) {
        case 'between':
          tempObj[key] = {
            select: true,
            value: {
              ...data[key],
            },
          };
          break;
        default:
          if (key === 'latestPaidOrderTime' && data[key]) {
            tempObj[key] = {
              select: true,
              value: [data[key].startValue, data[key].endValue],
            };
          } else {
            tempObj[key] = data[key];
          }
          break;
      }
      if (tempObj[key].value && tempObj[key].value.select) {
        delete tempObj[key].value.select;
      }
    } else {
      switch (type) {
        case 'range':
          tempObj[key] = {
            select: false,
            endValue: null,
            startValue: null,
          };
          break;
        case 'between':
          tempObj[key] = {
            select: false,
            value: {
              operator: 'BETWEEN',
              endValue: null,
              startValue: null,
            },
          };
          break;
        case 'array':
          tempObj[key] = {
            select: false,
            value: [],
          };
          break;
        case 'select':
          tempObj[key] = {
            select: false,
            value: null,
          };
          break;
        default:
          tempObj[key] = {
            select: false,
          };
      }
    }
  });
  console.log(tempObj);
  return tempObj;
}
