// import axios from 'axios';
import config from '../../config';
const { limitApi } = config;
const menus = [
  {
    node: {
      id: '8c0507d1-01a2-4c1d-899d-2e579b0606b3',
      name: '首页',
      picture: 'android-apps',
      type: {
        name: '菜单',
        value: 2,
      },
      uri: 'dashboard',
    },
    childNodes: [],
  },
  {
    node: {
      id: '5e7b7c80-642c-493c-b1e0-0eb1514a76c5',
      name: '显示配置',
      picture: 'android-phone-portrait',
      type: {
        name: '资源组',
        value: 1,
      },
      uri: '',
    },
    childNodes: [
      {
        node: {
          id: 'b6bef76d-4824-482e-b561-ccd71da20904',
          name: '广告位列表',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'adList',
        },
        childNodes: [],
      },
      {
        node: {
          id: 'dbeaef7d-acf7-4d27-9432-9421bb5743f0',
          name: '借款首页',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'loanHomePage',
        },
        childNodes: [],
      },
    ],
  },
  {
    node: {
      id: '4a98a32b-d355-4a44-bc1b-b80a8a0dab07',
      name: '发送管理',
      picture: 'android-send',
      type: {
        name: '资源组',
        value: 1,
      },
      uri: null,
    },
    childNodes: [
      {
        node: {
          id: 'cce0447d-e501-424f-8653-372dd92c9d6f',
          name: '策略管理',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'strategyManage',
        },
        childNodes: [],
      },
      {
        node: {
          id: 'b6555eaf-039c-4fc6-8140-ccf7261f93fa',
          name: '消息模板管理',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'templateManage',
        },
        childNodes: [],
      },
      {
        node: {
          id: 'a8327084-7897-44cf-941b-ce1436ec8073',
          name: '发送营销短信',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'createMessage',
        },
        childNodes: [],
      },
      {
        node: {
          id: '64eb1731-638c-4069-aa97-8d7536fcfb08',
          name: '发送push',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'sendPush',
        },
        childNodes: [],
      },
      {
        node: {
          id: 'af55a0bd-d9e5-4280-9a88-12d7c85f5b2c',
          name: '发送站内信',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'sendMail',
        },
        childNodes: [],
      },
      {
        node: {
          id: '701d7e9e-81cd-42e9-b51d-f89425f8f09a',
          name: '短信节点管理',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'smsNodeManage',
        },
        childNodes: [],
      },
      {
        node: {
          id: 'ce4a8436-2cff-49e6-8f1a-e7a66b3dfc38',
          name: '消息发送记录',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'infoSendRecord',
        },
        childNodes: [],
      },
      {
        node: {
          id: '6d87d1f2-6122-414a-9aee-bb4256562217',
          name: '营销短信黑名单',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'blacklist',
        },
        childNodes: [],
      },
      {
        node: {
          id: 'dde9bb49-97cb-417e-b890-5cdee4bd12e1',
          name: '长链接转短链接',
          picture: 'shuffle',
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'linkTransform',
        },
        childNodes: [],
      },
    ],
  },
  {
    node: {
      id: '4e60214c-66b5-4d29-ac74-d7e736ccf061',
      name: 'app后台管理',
      picture: 'ios-settings',
      type: {
        name: '资源组',
        value: 1,
      },
      uri: '',
    },
    childNodes: [
      {
        node: {
          id: '3a1cedbf-f4d6-4fe7-bcfc-8d2f327ca6cc',
          name: '组件配置记录',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'appconfig',
        },
        childNodes: [],
      },
      {
        node: {
          id: '3a1cedbf-f4d6-4fe7-bcfc-8d2f327ca6cc',
          name: '顶部导航',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'topNavigation',
        },
        childNodes: [],
      },
      {
        node: {
          id: '3a1cedbf-f4d6-4fe7-bcfc-8d2f327ca6cc',
          name: 'TAB配置',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'tabDeploy',
        },
        childNodes: [],
      },
    ],
  },
  {
    node: {
      id: '106ef69f-97f1-49b8-b76b-c7a68d97b12e',
      name: '弹窗管理',
      picture: 'ios-chatbubble',
      type: {
        name: '资源组',
        value: 1,
      },
      uri: null,
    },
    childNodes: [
      {
        node: {
          id: 'db293ebc-128d-4a4b-913a-928c5b39a725',
          name: '弹窗配置',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'appPopup',
        },
        childNodes: [],
      },
    ],
  },
  {
    node: {
      id: '7433ebb0-0860-4fdc-aabc-70db41e22779',
      name: '奖券管理',
      picture: 'ios-settings',
      type: {
        name: '资源组',
        value: 1,
      },
      uri: null,
    },
    childNodes: [
      {
        node: {
          id: '0ca2b4dd-7411-4b0c-8527-49b09dc17d8a',
          name: '优惠券发行记录',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'couponRecord',
        },
        childNodes: [],
      },
      {
        node: {
          id: '74d861a6-8abd-4755-9518-cf0e60b8583c',
          name: '优惠券列表查询',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'couponQuery',
        },
        childNodes: [],
      },
      {
        node: {
          id: '1b1f4661-dd9a-44bc-8fa0-c380877ac689',
          name: '优惠券消费记录',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'couponConsumption',
        },
        childNodes: [],
      },
    ],
  },
  {
    node: {
      id: '119d1160-c446-4370-8d50-8fd749ebb39c',
      name: '积分',
      picture: 'ios-list',
      type: {
        name: '资源组',
        value: 1,
      },
      uri: null,
    },
    childNodes: [
      {
        node: {
          id: '43a9714d-84da-459e-9182-55e06e5e717d',
          name: '积分列表',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'pointList',
        },
        childNodes: [],
      },
      {
        node: {
          id: 'c13c3287-5580-4b2e-b979-bd58e5f11554',
          name: '积分明细记录',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'pointRecord',
        },
        childNodes: [],
      },
    ],
  },
  {
    node: {
      id: 'aac922c9-4c5d-48c5-a747-400c493806bf',
      name: '用户管理',
      picture: 'checkmark-circled',
      type: {
        name: '资源组',
        value: 1,
      },
      uri: null,
    },
    childNodes: [
      {
        node: {
          id: '7fec0d98-8693-9f90-7d8e-770f958fda4a',
          name: '用户分群',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'userGroup',
        },
        childNodes: [],
      },
      {
        node: {
          id: '81244b9e-3bf0-4487-b3c0-4c2767fb9ea0',
          name: '邀请好友记录',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'friendRecord',
        },
        childNodes: [],
      },
    ],
  },
  {
    node: {
      id: '580b8099-2c3b-43a6-8c5d-0edfc757ee38',
      name: '活动管理',
      picture: null,
      type: {
        name: '资源组',
        value: 1,
      },
      uri: null,
    },
    childNodes: [
      {
        node: {
          id: '7c6edd73-d28a-4fb6-8f7f-864e1c82be38',
          name: '活动专题列表',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'activityTopicList',
        },
        childNodes: [],
      },
      {
        node: {
          id: '7c6edd73-d28a-4fb6-8f7f-864e1c82be38',
          name: '拼团订单查询',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'orderQuery',
        },
        childNodes: [],
      },
    ],
  },
  {
    node: {
      id: '89deb3bc-f794-4dfa-b63f-5d0ce49a06eb',
      name: '活动商品管理',
      picture: null,
      type: {
        name: '资源组',
        value: 1,
      },
      uri: null,
    },
    childNodes: [
      {
        node: {
          id: '856dfba6-9a0b-4037-ad68-a7abbf6c2088',
          name: '商品专题列表',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'specialList',
        },
        childNodes: [],
      },
      {
        node: {
          id: 'ff9b6e90-3bdb-4e98-b6f1-5c7635fdf033',
          name: '商品标签列表',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'labelList',
        },
        childNodes: [],
      },
      {
        node: {
          id: 'e8be713e-aaf1-470a-81d3-67ad15d59c61',
          name: '商品列表',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'productList',
        },
        childNodes: [],
      },
      {
        node: {
          id: 'e8be713e-aaf1-470a-81d3-67ad15d59c61',
          name: '支付限额商品列表',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'cashPayList',
        },
        childNodes: [],
      },
    ],
  },
  {
    node: {
      id: '72f586b1-a65b-45fb-847a-cf11c3b56bc3',
      name: '活动模版管理',
      picture: 'ios-settings',
      type: {
        name: '资源组',
        value: 1,
      },
      uri: null,
    },
    childNodes: [
      {
        node: {
          id: 'f802681d-cf34-4eff-8838-1839ebe54bc3',
          name: '活动模版管理',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'activeTemplateManage',
        },
        childNodes: [],
      },
    ],
  },
  {
    node: {
      id: '72f586b1-a65b-45fb-847a-cf11c3b56bc3',
      name: '流量工厂',
      picture: 'ios-settings',
      type: {
        name: '资源组',
        value: 1,
      },
      uri: null,
    },
    childNodes: [
      {
        node: {
          id: 'f802681d-cf34-4eff-8838-1839ebe54bc3',
          name: 'KA管理',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'kaManage',
        },
        childNodes: [],
      },
      {
        node: {
          id: 'f802681d-cf34-4eff-8838-1839ebe54bc3',
          name: '营销配置',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'marketingAllocation',
        },
        childNodes: [],
      },
    ],
  },
  {
    node: {
      id: '72f586b1-a65b-45fb-847a-cf11c3b56bc3',
      name: '会员权益',
      picture: 'ios-settings',
      type: {
        name: '资源组',
        value: 1,
      },
      uri: null,
    },
    childNodes: [
      {
        node: {
          id: 'f802681d-cf34-4eff-8838-1839ebe54bc3',
          name: '会员等级',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'memberLevel',
        },
        childNodes: [],
      },
      {
        node: {
          id: 'f802681d-cf34-4eff-8838-1839ebe54bc3',
          name: '等级权益',
          picture: null,
          type: {
            name: '菜单',
            value: 2,
          },
          uri: 'memberRights',
        },
        childNodes: [],
      },
    ],
  },
];

// user manage api
export function userInfo() {
  return http.get(`${limitApi}/oauth/currentuserinfo`);
}
export function getMenuData() {
  return http.post(`${limitApi}/user/getresources/APP003`);
}
export function normalization(menuData = menus) {
  const value = [];
  const data = [...menuData];
  data.forEach(item => {
    let obj = {};
    obj = { ...item.node };
    obj.path = obj.uri;
    obj.icon = obj.picture;
    if (item.childNodes.length) {
      obj.children = normalization(item.childNodes);
    } else {
      obj.children = [];
    }
    value.push(obj);
  });
  return value;
}
