import qs from 'qs';
import fileSaver from 'file-saver';
import config from '../../config';
import { getDate } from '../util';

const { appApi } = config;
// appApi = 'https://opapi-vcc3.liangkebang.net/kdspOp'
export default {
  // 查询渠道列表
  getChannelList(params) {
    return http.get(`${appApi}/api/kdsp/op/ka/channel/list?${qs.stringify(params)}`);
  },
  // 查询（合作类型）简版
  getCooperationType() {
    return http.get(`${appApi}/api/kdsp/op/ka/channel/cooperation_type`);
  },
  // 查询子渠道列表
  getChildList(params) {
    return http.get(`${appApi}/api/kdsp/op/ka/query_childList?${qs.stringify(params)}`);
  },
  // 更新子渠道状态
  updateChildStatus(params) {
    return http.post(`${appApi}/api/kdsp/op/ka/update_child_status`, qs.stringify(params));
  },
  // 增加渠道信息
  addInfo(params) {
    return http.post(`${appApi}/api/kdsp/op/ka/add_info`, qs.stringify(params));
  },
  // 查询某渠道对应的数据信息
  queryAll(params) {
    return http.get(`${appApi}/api/kdsp/op/ka/query_all?${qs.stringify(params)}`);
  },
  // 下载excel（导出链接）
  download(params) {
    return http
      .post(`${appApi}/api/kdsp/op/ka/channel/ka-detail-downLoad`, qs.stringify(params), {
        responseType: 'arraybuffer',
      })
      .then(data => {
        if (data.byteLength > 0) {
          const blob = new Blob([data], { type: 'application/vnd.ms-excel;' });
          fileSaver.saveAs(blob, `KA合作列表_${getDate()}.xls`);
        }
      });
  },
  // 查询KA流程配置组（合作类型）
  getProcessGroup(params) {
    return http.get(`${appApi}/api/kdsp/op/ka/query_process_group?${qs.stringify(params)}`);
  },
  // 批量修改主渠道状态
  batchUpdate(params) {
    return http.post(`${appApi}/api/kdsp/op/ka/batch_update_status`, qs.stringify(params));
  },
  // 渠道信息修改
  updateInfo(params) {
    return http.post(`${appApi}/api/kdsp/op/ka/update_info`, qs.stringify(params));
  },
};
