import config from '../../config';
export const defaultPageType = [
  {
    title: '精选页',
    value: 'home',
  },
  {
    title: '发现页',
    value: 'discovery',
  },
  {
    title: '我的',
    value: 'profile',
  },
];
export const locationList = [1, 2, 3, 4, 5];
export const showList = [
  {
    title: '点击后隐藏',
    value: 1,
  },
  {
    title: '长亮',
    value: 2,
  },
];
export const productList = [
  {
    title: '现金分期',
    value: 1,
  },
  {
    title: '无息',
    value: 2,
  },
];
export const user = [
  {
    title: '未登录',
    value: -1,
  },
  {
    title: '未申请',
    value: 1,
  },
  {
    title: '审核中',
    value: 2,
  },
  {
    title: '审核通过待提现',
    value: 3,
  },
  {
    title: '放款中',
    value: 4,
  },
  {
    title: '放款失败',
    value: 5,
  },
  {
    title: '审核拒绝',
    value: 7,
  },
  {
    title: '再来一单',
    value: 8,
  },
  {
    title: '多订单还款中',
    value: 9,
  },
  {
    title: '七日有待还',
    value: 11,
  },
  {
    title: '七日无待还',
    value: 12,
  },
  {
    title: '已逾期',
    value: 14,
  },
  {
    title: '二类户',
    value: 13,
  },
];
export const type = [
  {
    title: '文字链(8.0及以后版本作废)',
    value: 1,
  },
  // {
  //   title: '活动导航页去掉',
  //   value: 2,
  // },
  {
    title: '老banner',
    value: 3,
  },
  // {
  //   title: '活动日历去掉',
  //   value: 8,
  // },
  // {
  //   title: '活动页面banner去掉',
  //   value: 5,
  // },
  {
    title: '金刚区',
    value: 4,
  },
  {
    title: '运营区-横向',
    value: 51,
  },
  {
    title: '通栏',
    value: 10,
  },
  {
    title: '新banner',
    value: 11,
  },
  {
    title: '运营区-竖向',
    value: 52,
  },
  // {
  //   title: '瀑布流导航先不测',
  //   value: 6,
  // },
  {
    title: '侧边栏浮窗',
    value: 7,
  },
  {
    title: '顶部悬浮窗(8.1及以后版本作废)',
    value: 2,
  },
  {
    title: '顶部导航(8.0及以后版本作废)',
    value: 9,
  },
  {
    title: '品类楼层',
    value: 101,
  },
  {
    title: '图文活动',
    value: 102,
  },
];
export const statusList = [
  {
    title: '未发布',
    value: 1,
  },
  {
    title: '已发布',
    value: 2,
  },
  {
    title: '已下线',
    value: 3,
  },
];
export const personList = [
  {
    title: '通用用户',
    value: 1,
  },
  {
    title: '新用户',
    value: 2,
  },
  {
    title: '有额度未购物用户',
    value: 3,
  },
  {
    title: '公司员工',
    value: 4,
  },
  {
    title: '指定用户',
    value: 5,
  },
];
export const appType = [
  {
    title: 'APP',
    value: 1,
  },
  {
    title: '小程序',
    value: 2,
  },
  {
    title: 'h5',
    value: 3,
  },
];
export const viewUser = [
  {
    title: '全部用户',
    value: 1,
  },
  {
    title: '白名单用户',
    value: 2,
  },
  {
    title: '指定用户',
    value: 3,
  },
];
export const ableList = [
  {
    title: '启用',
    value: 'VALID',
  },
  {
    title: '停用',
    value: 'NO_VALID',
  },
];
export const showListPop = [
  {
    title: '每天仅弹出一次',
    value: 1,
    type: 'activity',
  },
  {
    title: '点击后不再弹出',
    value: 2,
    type: 'activity',
  },
  { title: '关闭后不再弹出', value: 3, type: 'activity' },
  { title: '每次启动弹出', value: 4, type: 'activity' },
  // { title: '每次进入页面弹出', value: 5, type: 'deten' },
];
const host = config.hostUrl;
// const host = 'vcc-spider.xyqb.com';
export const pageTypePop = [
  {
    title: '精选页',
    value: 'home',
    type: 'activity',
  },
  {
    title: '发现页',
    value: 'discovery',
    type: 'activity',
  },
  {
    title: '我的页面',
    value: 'profile',
    type: 'activity',
  },
  {
    title: '消费额度申请页',
    value: `${host}/auth-page`, // 现金分期和vcc路由重复，需要加上域名区分
    type: 'deten',
  },
  {
    title: '身份认证页',
    value: `${host}/setXyqbIdCard`,
    type: 'deten',
  },
  {
    title: '审核成功待开户页',
    value: `${host}/creditSuccess`,
    type: 'deten',
  },
  {
    title: '活体认证页',
    value: `${host}/face`,
    type: 'deten',
  },
  {
    title: '基本信息页',
    value: `${host}/userInfo`,
    type: 'deten',
  },
  {
    title: '绑卡开户页',
    value: `${host}/quotaActivation`,
    type: 'deten',
  },
  {
    title: '享花卡新人大礼包',
    value: `/activity/newsGift`,
    type: 'deten',
  },
];
