import moment from 'moment';
export function deepCopy(data) {
  return JSON.parse(JSON.stringify(data));
}
export function isInteger(data) {
  // 是否是正整数
  const reg = /^((?!0)\d{1,})$/;
  return reg.test(data);
}
export function isNumber(data) {
  const reg = /^(\d{1,})$/;
  return reg.test(data);
}
export function percent(numerator, denominator) {
  if (denominator === 0) {
    return 0;
  }
  return Math.round((numerator / denominator) * 10000) / 100 + '%';
}
export function getTime(time, format = 'YYYY-MM-DD HH:mm:ss') {
  if (!time) return '';
  return moment(time).format(format);
}
export function addDay(time, day = 1) {
  if (!time) return '';
  return getTime(moment(time).add(day, 'day'));
}
export function dayEnd(time) {
  if (!time) return '';
  return getTime(moment(time).endOf('day'));
}
export function debounce(fn, delay = 500) {
  let timer = null;

  return function() {
    const args = arguments;

    if (timer) {
      clearTimeout(timer);
    }

    timer = setTimeout(
      function() {
        timer = null;
        fn.apply(this, args);
      }.bind(this),
      delay
    );
  };
}
// 展示table列表value-title
export function showTitle(key, data, params, valueKey = 'value', showKey = 'title') {
  const obj = data.find(item => item[valueKey] === params.row[key]);
  return (obj && obj[showKey]) || '';
}

export function getDate() {
  return moment().format('YYYYMMDDHHmmss');
}
export function firstCodeToUpperOrLower(str, isUpper = true) {
  var reg = /\b(\w)|\s(\w)/g;
  return str.replace(reg, function(m) {
    if (!isUpper) {
      return m.toLowerCase();
    }
    return m.toUpperCase();
  });
}
export function isObject(val) {
  return Object.prototype.toString.call(val) === '[object Object]';
}
export function isArray(val) {
  return Object.prototype.toString.call(val) === '[object Array]';
}
