import config from '../../config';
import qs from 'qs';
import fileSaver from 'file-saver';
const { appApi } = config;
// let appApi = 'http://192.168.28.41';
export default {
  // 获取微信模板ID
  getTemplates(params) {
    // console.log(params);
    return http.get(`${appApi}/api/kdsp/weixin/getTemplates?${qs.stringify(params)}`, {
      headers: {
        'Content-Type': 'application/json',
      },
    });
  },
  // 真实下载（含手机号）
  downloadPhone() {
    return http.get(`${appApi}/api/kdsp/weixin/example_download`, {
      headers: {
        'Content-Type': 'application/json',
      },
    });
  },
  // 微信模板上传并转换
  sendMsg(params) {
    // return http.post(`${appApi}/api/kdsp/weixin/sendMsg`, params, {
    //     headers: {
    //         'Content-Type': 'multipart/form-data',
    //     }
    // });
    const form = new FormData();
    for (const key in params) {
      form.append(key, params[key]);
    }
    return http.post(`${appApi}/api/kdsp/weixin/sendMsg`, form);
  },

  onDownLoad() {
    return http
      .post(`${appApi}/api/kdsp/weixin/example_download`, null, {
        responseType: 'arraybuffer',
      })
      .then(data => {
        if (data.byteLength > 0) {
          const blob = new Blob([data], { type: 'application/vnd.ms-excel;' });
          fileSaver.saveAs(blob, `公众号通知消息模板.xls`);
        }
      });
  },
};
