module.exports = {
  root: true,
  parserOptions: {
    parser: 'babel-eslint',
  },
  env: {
    browser: true,
    node: true,

  },
  extends: [
    'plugin:vue/essential',
    // "plugin:vue/recommended", 
    "eslint:recommended",
    // "@vue/prettier"
  ],
  plugins: [
    'vue',
    'html',
    'prettier',
  ],
  rules: {
    'prettier/prettier': 'error',
    // 防止iview的标签报错
    'vue/no-parsing-error': [2, { 'x-invalid-end-tag': false }],
    'eqeqeq': 'off',

    'vue/max-attributes-per-line': 'off',
    'no-empty': ["error", { "allowEmptyCatch": true }],
    'vue/no-v-html': 'off',
    'vue/require-default-prop': 'off',
    'arrow-parens': 'off', // allow paren-less arrow functions
    'generator-star-spacing': 'off', // allow async-await
    'no-unused-vars': 'error', // disabled no ununsed var
    'no-debugger': process.env.NODE_ENV === 'production' ? 'error' : 'off', // no use debugger in production
    'indent': [2, 2, { SwitchCase: 1 }], // 2 space for tab for perttier
    // 'space-before-function-paren': ['error', 'never'], // no space in function name for perttier
    'no-console': ["off", { allow: ["warn", "error"] }],
    "prefer-const": 2,//首选const

  },
  globals: {
    Qiniu: true,
    moment: true,
    http: true,
    LocalStorage: true,
    Cookies: true,
    Bus: true,
  }
}

