import config from '../../config';
import fileSaver from 'file-saver';
import { getDate } from '../util';
const { appApi } = config;
import qs from 'qs';
export default {
  // 获取商品类目
  categoryQuery() {
    return http.get(`${appApi}/api/kdsp/op/rear-category/query/all`);
  },
  // 商品列表-查询
  skuInfo(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/sku-info/list`, params);
  },
  // 商品列表-修改反显数据查询
  skuInfoList(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/sku-info/get`, params);
  },

  // 商品管理-商品列表-修改
  skuInfoUpdate(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/sku-info/update`, params);
  },

  // 商品管理-获取商品标签列表
  labelInfoList(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/label-info/list`, params);
  },

  // 批量标记商品
  markTag(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/sku-info/adds-label`, params);
  },
  // 批量下架商品
  updatesOffline(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/sku-info/updates-offline`, qs.stringify(params), {
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded',
      },
    });
  },
  // 商品管理-商品标签列表_分页
  listPage(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/label-info/list-page`, params);
    // return http.post(`${appApi}/api/kdsp/activity/activity-goods/label-info/list`, params);
  },
  // 商品管理-商品标签列表_新增
  labelInfoAdd(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/label-info/add`, params);
  },
  // 商品管理-商品标签列表_修改
  labelInfoUpdate(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/label-info/update`, params, {
      headers: {
        'Content-Type': '	application/json',
      },
    });
  },
  // 修改状态
  getStatus(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/label-info/update-status`, params);
  },
  // 商品管理-商品专题列表_分页
  specialPage(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/special/list-page`, params);
  },
  // 商品管理-商品专题列表_新增专题
  specialAdd(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/special/add`, params, {
      headers: {
        'Content-Type': '	application/json',
      },
    });
  },
  // 商品管理-商品专题列表_修改专题
  specialUpdate(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/special/update`, params, {
      headers: {
        'Content-Type': '	application/json',
      },
    });
  },
  specialGet(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/special/get`, params, {
      // return http.post(`http://192.168.29.79/api/kdsp/activity/activity-goods/special/get`, params, {
      headers: {
        'Content-Type': '	application/json',
      },
    });
  },
  // 商品管理-商品专题列表_删除专题下标签
  specialDeleteLabel(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/special/delete-label`, qs.stringify(params));
  },

  // 商品管理-商品专题列表_排序列表
  specialRank(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/special-detail/list-page`, params);
  },
  // 商品管理-商品专题列表_修改专题商品
  updateGoods(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/special-detail/update`, params);
  },

  // 查询完成结点
  nodeList() {
    return http.get(`${appApi}/api/kdsp/points/task/node/list`);
  },

  // 准备下载商品专题数据
  readyLoad(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/special-detail/ready-load`, params);
  },

  // 批量上传标记商品
  batchLable(file) {
    const params = new FormData();
    params.append('file', file);
    return http.post(`${appApi}/api/kdsp/sku/sku-info/batch_lable`, params);
  },

  // 商品渠道
  getSkuSource() {
    return http.post(`${appApi}/api/kdsp/sku/sku-info/getSkuSource`);
  },

  // 下载商品列表
  pullSku(params) {
    return http
      .post(`${appApi}/api/kdsp/sku/sku-info/pull_valid_sku`, qs.stringify(params), {
        responseType: 'arraybuffer',
      })
      .then(data => {
        if (data.byteLength > 0) {
          const blob = new Blob([data], { type: 'application/vnd.ms-excel;' });
          fileSaver.saveAs(blob, `商品列表${getDate()}.xls`);
        }
      });
  },

  // 下载模板
  templateDown() {
    return http
      .post(`${appApi}/api/kdsp/sku/sku-info/example_download`, null, {
        responseType: 'arraybuffer',
      })
      .then(data => {
        if (data.byteLength > 0) {
          const blob = new Blob([data], { type: 'application/vnd.ms-excel;' });
          fileSaver.saveAs(blob, `标记商品模板.xls`);
        }
      });
  },
  // 获取标签下的商品列表
  getLabelProductList(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/label-info/sku-label/list-page`, params);
  },
  downloadProductByLabel(params) {
    return http
      .post(`${appApi}/api/kdsp/activity/activity-goods/label-info/download`, params, {
        responseType: 'arraybuffer',
      })
      .then(data => {
        if (data.byteLength > 0) {
          const blob = new Blob([data], { type: 'application/vnd.ms-excel;' });
          fileSaver.saveAs(blob, `${params.id}-${params.labelName}标签商品列表.xls`);
        }
      });
  },
  // 导出限额支付的商品数据
  exportCashList() {
    return http
      .get(`${appApi}/api/kdsp/new-user/exclusive/sku-limit/export`, {
        responseType: 'arraybuffer',
      })
      .then(data => {
        if (data.byteLength > 0) {
          const blob = new Blob([data], { type: 'application/vnd.ms-excel;' });
          fileSaver.saveAs(blob, `支付限额的商品数据列表.xlsx`);
        }
      });
  },
  // 添加限额支付限制商品
  getCashLimitList(params) {
    return http.post(`${appApi}/api/kdsp/new-user/exclusive/sku-limit/submit`, params);
  },
  // 限额支付页停用启用按钮
  updateStatus(params) {
    return http.get(`${appApi}/api/kdsp/new-user/exclusive/sku-limit/start-stop?enable=${params.enable}`);
  },
  changeProductLableStatus(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/label-info/sku-label/update`, params);
  },
  getSpecialPreview(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/special/preview`, params);
  },
  specialPreviewSaveNext(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/special/preview/save-next`, params);
  },
  // 保存时候检查
  specialSaveCheck(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/special/check-save`, params);
  },
  specialSaveNew(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/special/save-new`, params);
  },

  specialUpdateNew(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/special/update-new`, params);
  },

  specialDownloadTemplate(params) {
    return http
      .post(`${appApi}/api/kdsp/activity/activity-goods/special/download-template`, params, {
        responseType: 'arraybuffer',
      })
      .then(data => {
        if (data.byteLength > 0) {
          const blob = new Blob([data], { type: 'application/vnd.ms-excel;' });
          fileSaver.saveAs(blob, `商品列表.xls`);
        }
      });
  },
  specialUploadTemplate(file, previewId) {
    const params = new FormData();
    params.append('file', file);
    params.append('previewId', previewId);
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/special/upload-template`, params);
  },
  // 获取现金支付的已有数据
  getCashList() {
    return http.get(`${appApi}/api/kdsp/new-user/exclusive/sku-limit/get`);
  },
  // 查看详情
  lookDetails(params) {
    return http.get(`${appApi}/api/kdsp/new-user/exclusive/sku-limit/page?${qs.stringify(params)}`);
  },
};
