import Vue from 'vue';
import VueRouter from 'vue-router';

Vue.use(VueRouter);

const home = r => require.ensure([], () => r(require('../view/common/Home.vue')), 'home');
const micro = r => require.ensure([], () => r(require('../view/common/Micro.vue')), 'microLayout');
const adList = r => require.ensure([], () => r(require('../view/operation/AdList.vue')), 'adList');
const newAdList = r => require.ensure([], () => r(require('../view/operation/newAdList.vue')), 'newAdList');
const userManage = r => require.ensure([], () => r(require('../view/userManage/index.vue')), 'userManage');
const dayConsumeAnalysis = r => require.ensure([], () => r(require('../view/statementManage/dayConsumeAnalysis.vue')), 'dayConsumeAnalysis');
const expenditure = r => require.ensure([], () => r(require('../view/statementManage/expenditure.vue')), 'expenditure');
const wxPayRecord = r => require.ensure([], () => r(require('../view/statementManage/wxPayRecord.vue')), 'wxPayRecord');
const invoiceRecord = r => require.ensure([], () => r(require('../view/statementManage/invoiceRecord.vue')), 'invoiceRecord');

// const loanHomePage = r => require.ensure([], () => r(require('../view/operation/LoanHomePage.vue')), 'loanHomePage');
const templateManage = r => require.ensure([], () => r(require('../view/sendManagement/templateManage.vue')), 'templateManage');
const strategyManage = r => require.ensure([], () => r(require('../view/sendManagement/StrategyManage.vue')), 'strategyManage');
const createMessage = r => require.ensure([], () => r(require('../view/sendManagement/CreateMessage.vue')), 'CreateMessage');
const dashboard = r => require.ensure([], () => r(require('../view/common/Dashboard.vue')), 'dashboard');

const sendPush = r => require.ensure([], () => r(require('../view/sendManagement/sendPush.vue')), 'sendPush');
const sendMail = r => require.ensure([], () => r(require('../view/sendManagement/sendMail.vue')), 'sendMail');

const linkTransform = r => require.ensure([], () => r(require('../view/sendManagement/linkTransform.vue')), 'linkTransform');
// 会员中心
const pointList = r => require.ensure([], () => r(require('../view/myPoint/pointList.vue')), 'pointList');
const pointRecord = r => require.ensure([], () => r(require('../view/myPoint/pointRecord.vue')), 'pointRecord');
const memberLevel = r => require.ensure([], () => r(require('../view/member/memberLevel.vue')), 'memberLevel');
const memberRights = r => require.ensure([], () => r(require('../view/member/memberRights.vue')), 'memberRights');
// 用户管理
const friendRecord = r => require.ensure([], () => r(require('../view/userManagement/friendRecord.vue')), 'friendRecord');
// 奖券管理
const couponRecord = r => require.ensure([], () => r(require('../view/couponManagement/couponRecord.vue')), 'couponRecord');
const couponQuery = r => require.ensure([], () => r(require('../view/couponManagement/couponQuery.vue')), 'couponQuery');
const couponConsumption = r => require.ensure([], () => r(require('../view/couponManagement/couponConsumption.vue')), 'couponConsumption');

const smsNodeManage = r => require.ensure([], () => r(require('../view/sendManagement/smsNodeManage.vue')), 'smsNodeManage');
const infoSendRecord = r => require.ensure([], () => r(require('../view/sendManagement/infoSendRecord.vue')), 'infoSendRecord');
const blacklist = r => require.ensure([], () => r(require('../view/sendManagement/blacklist.vue')), 'blacklist');
const appconfig = r => require.ensure([], () => r(require('../view/appconfig/appConfig.vue')), 'appconfig');
const topNavigation = r => require.ensure([], () => r(require('../view/appconfig/topNavigation.vue')), 'topNavigation');
const tabDeploy = r => require.ensure([], () => r(require('../view/tabDeploy/tabDeploy.vue')), 'tabDeploy');
const appPopup = r => require.ensure([], () => r(require('../view/appPopup')), 'appPopup');

// 活动管理
const activityTopicList = r => require.ensure([], () => r(require('../view/activityManag/activityTopicList.vue')), 'activityactivityTopicList');
const orderQuery = r => require.ensure([], () => r(require('../view/activityManag/orderQuery.vue')), 'orderQuery');

// 活动商品管理
const specialList = r => require.ensure([], () => r(require('../view/activityGoodManag/specialList')), 'specialList');
const labelList = r => require.ensure([], () => r(require('../view/activityGoodManag/labelList')), 'labelList');
const productList = r => require.ensure([], () => r(require('../view/activityGoodManag/productList')), 'productList');
const activeTemplateManage = r => require.ensure([], () => r(require('../view/activeTemplateManage')), 'activeTemplateManage');

// 公众号通知消息模块
const wechatMessage = r => require.ensure([], () => r(require('../view/wechatMessage/wechatMessage.vue')), 'wechatMessage');

// 流量工厂模块
const kaManage = r => require.ensure([], () => r(require('../view/trafficFactory/kaManage.vue')), 'kaManage');
const userGroup = r => require.ensure([], () => r(require('../view/userGroup')), 'userGroup');

const marketingAllocation = r => require.ensure([], () => r(require('../view/trafficFactory/marketingAllocation.vue')), 'kaManage');

const homePageLayout = r => require.ensure([], () => r(require('../view/homePageLayout/index.vue')), 'homePageLayout');

// 微信公众号登录页图片上传
const officialLanding = r => require.ensure([], () => r(require('../view/privateManage/officialLanding.vue')), 'officialLanding');

const routes = [
  {
    path: '/',
    redirect: '/home/dashboard',
  },
  {
    path: '/home',
    component: window.__POWERED_BY_QIANKUN__ ? micro : home,
    meta: {
      requireAuth: true,
    },
    children: [
      {
        path: 'invoiceRecord',
        component: invoiceRecord,
      },
      {
        path: 'wxPayRecord',
        component: wxPayRecord,
      },
      {
        path: 'expenditure',
        component: expenditure,
      },
      {
        path: 'dayConsumeAnalysis',
        component: dayConsumeAnalysis,
      },
      {
        path: 'userManage',
        component: userManage,
      },
      {
        path: 'adList',
        component: adList,
      },
      {
        path: 'specialList',
        component: specialList,
      },
      {
        path: 'labelList',
        component: labelList,
      },
      {
        path: 'productList',
        component: productList,
      },
      {
        path: 'couponConsumption',
        component: couponConsumption,
      },
      {
        path: 'couponQuery',
        component: couponQuery,
      },
      {
        path: 'couponRecord',
        component: couponRecord,
      },
      {
        path: 'activityTopicList',
        component: activityTopicList,
      },
      {
        path: 'orderQuery',
        component: orderQuery,
      },
      {
        path: 'activityTopicList',
        component: activityTopicList,
      },
      {
        path: 'friendRecord',
        component: friendRecord,
      },
      {
        path: 'pointList',
        component: pointList,
      },
      {
        path: 'appPopup',
        component: appPopup,
      },
      {
        path: 'pointRecord',
        component: pointRecord,
      },
      {
        path: 'dashboard',
        component: dashboard,
      },
      {
        path: 'createMessage',
        component: createMessage,
      },
      // {
      //   path: 'adList',
      //   component: adList,
      // },
      {
        path: 'newAdList',
        component: newAdList,
      },
      {
        path: 'memberRights',
        component: memberRights,
      },
      {
        path: 'memberLevel',
        component: memberLevel,
      },

      // {
      //   path: 'loanHomePage',
      //   component: loanHomePage,
      // },
      {
        path: 'templateManage',
        component: templateManage,
      },
      {
        path: 'strategyManage',
        component: strategyManage,
      },
      {
        path: 'sendPush',
        component: sendPush,
      },
      {
        path: 'sendMail',
        component: sendMail,
      },
      {
        path: 'smsNodeManage',
        component: smsNodeManage,
      },
      {
        path: 'infoSendRecord',
        component: infoSendRecord,
      },
      {
        path: 'blacklist',
        component: blacklist,
      },
      {
        path: 'appconfig',
        component: appconfig,
      },
      {
        path: 'appPopup',
        component: appPopup,
      },
      {
        path: 'activeTemplateManage',
        component: activeTemplateManage,
      },
      {
        path: 'linkTransform',
        component: linkTransform,
      },
      {
        path: 'wechatMessage',
        component: wechatMessage,
      },
      {
        path: 'kaManage',
        component: kaManage,
      },
      {
        path: 'userGroup',
        component: userGroup,
      },
      {
        path: 'marketingAllocation',
        component: marketingAllocation,
      },
      {
        path: 'homePageLayout',
        component: homePageLayout,
      },
      {
        path: 'topNavigation',
        component: topNavigation,
      },
      {
        path: 'tabDeploy',
        component: tabDeploy,
      },
      {
        path: 'officialLanding',
        component: officialLanding,
      },
    ],
  },
];

export default routes;
