export const cooperationStatusList = [
  {
    key: 1,
    desc: '未发布',
  },
  {
    key: 4,
    desc: '合作中',
  },
  {
    key: 5,
    desc: '停止合作',
  },
];
export const settlementList = [
  {
    key: 0,
    desc: 'CPA',
  },
  {
    key: 1,
    desc: 'CPS',
  },
];
// 是否撞库
export const isCollisionList = [
  {
    key: 1,
    desc: '是',
  },
  {
    key: 2,
    desc: '否',
  },
];
// 撞库类型
export const collisionTypeList = [
  {
    key: 0,
    desc: '其他',
  },
  {
    key: 1,
    desc: '羊小咩全量注册用户',
  },
  {
    key: 2,
    desc: '有过VCC授信申请客户',
  },
];
export const isSecretFreeList = [
  {
    key: 1,
    desc: '是',
  },
  {
    key: 2,
    desc: '否',
  },
];

export const channelPropertiesList = [
  {
    id: 'sexRates',
    desc: '性别比例',
  },
  {
    id: 'ageRangeRates',
    desc: '年龄区间比例',
  },
  {
    id: 'cityLevelRates',
    desc: '城市等级比例',
  },
  {
    id: 'consumLevelRates',
    desc: '消费等级比例',
  },
];

export const channelProperties = {
  sexRates: [
    {
      id: 0,
      desc: '未知',
    },
    {
      id: 1,
      desc: '女性',
    },
    {
      id: 2,
      desc: '男性',
    },
  ],
  ageRangeRates: [
    {
      id: 0,
      desc: '未知',
    },
    {
      id: 1,
      desc: '18岁以下',
    },
    {
      id: 2,
      desc: '18~24',
    },
    {
      id: 3,
      desc: '25~30',
    },
    {
      id: 4,
      desc: '31~35',
    },
    {
      id: 5,
      desc: '36~40',
    },
    {
      id: 6,
      desc: '41~45',
    },
    {
      id: 7,
      desc: '45以上',
    },
  ],
  cityLevelRates: [
    {
      id: 0,
      desc: '未知',
    },
    {
      id: 1,
      desc: '来自一线城市',
    },
    {
      id: 2,
      desc: '来自二线城市',
    },
    {
      id: 3,
      desc: '来自三线城市',
    },
    {
      id: 4,
      desc: '来自四线城市',
    },
    {
      id: 5,
      desc: '其它',
    },
  ],
  consumLevelRates: [
    {
      id: 0,
      desc: '未知',
    },
    {
      id: 1,
      desc: '1~1000',
    },
    {
      id: 2,
      desc: '1001~3000',
    },
    {
      id: 3,
      desc: '3001~5000',
    },
    {
      id: 4,
      desc: '5001~10000',
    },
    {
      id: 5,
      desc: '大于10000',
    },
  ],
};

const getCooperationStatus = status => {
  const cooperationStatusObj = cooperationStatusList.find(v => v.key === status);
  return cooperationStatusObj ? cooperationStatusObj.desc : '-';
};
export const kaManageColumns = function() {
  return [
    {
      type: 'selection',
      width: 60,
      align: 'center',
    },
    {
      key: 'channelNo',
      title: '父渠道编码',
      align: 'center',
    },
    {
      key: 'channelName',
      title: 'KA名称',
      align: 'center',
    },
    {
      key: 'owner',
      title: '所属团队',
      align: 'center',
      render: (h, params) => {
        const obj = kaOwnerList.find(item => item.key === params.row.owner) || {};
        return h('div', obj.desc);
      },
    },
    {
      key: 'processGroupName',
      title: '合作类型',
      align: 'center',
    },
    {
      key: 'cooperationStatus',
      title: '状态',
      align: 'center',
      render: (h, params) => {
        return h('div', getCooperationStatus(params.row.cooperationStatus));
      },
    },
    {
      key: 'childChannelCnt',
      title: '子KA数量',
      align: 'center',
    },
    {
      key: 'createdAt',
      title: '创建时间',
      width: 160,
      align: 'center',
    },
    {
      key: 'channelAttr',
      title: '渠道特征',
      align: 'center',
      minWidth: 120,
      render: (h, params) => {
        let texts = params.row.channelAttr;
        if (params.row.channelAttr) {
          if (params.row.channelAttr.length > 20) {
            texts = params.row.channelAttr.slice(0, 20) + '...';
          } else {
            texts = params.row.channelAttr;
          }
        }
        return h('div', [
          h(
            'Tooltip',
            {
              props: {
                placement: 'top',
                transfer: true,
              },
            },
            [
              texts,
              h(
                'div',
                {
                  slot: 'content',
                  style: {
                    width: '200px',
                    height: '100px',
                    overflowY: 'scroll',
                    whiteSpace: 'normal',
                    wordBreak: 'break-all',
                    wordWrap: 'break-word',
                  },
                },
                params.row.channelAttr
              ),
            ]
          ),
        ]);
      },
    },
    {
      key: 'action',
      title: '操作',
      align: 'center',
      width: 300,
      render: (h, params) => {
        const props = {
          type: 'primary',
        };
        const style = {
          display: 'inline-block',
          margin: '5px',
        };
        const btnArr = [
          h(
            'Button',
            {
              props,
              style,
              on: {
                click: () => {
                  this.editKa('edit', params.row);
                },
              },
            },
            '编辑'
          ),
          h(
            'Button',
            {
              props,
              style,
              on: {
                click: () => {
                  this.editKa('copy', params.row);
                },
              },
            },
            '复制'
          ),
          h(
            'Button',
            {
              props,
              style,
              on: {
                click: () => {
                  this.currentParentChannelNo = params.row.channelNo;
                  this.showChildChannel = true;
                },
              },
            },
            '数据'
          ),
          h(
            'Button',
            {
              props,
              style,
              on: {
                click: () => {
                  this.editKa('detail', params.row);
                },
              },
            },
            '...'
          ),
        ];
        return h(
          'div',
          {
            style: {
              // display: 'flex'
            },
          },
          btnArr
        );
      },
    },
  ];
};

export const childChannelColumns = function() {
  return [
    {
      key: 'channelNo',
      title: '渠道子编码',
      align: 'center',
    },
    {
      key: 'cooperationStatus',
      title: '状态',
      align: 'center',
      render: (h, params) => {
        return h('div', getCooperationStatus(params.row.cooperationStatus));
      },
    },
    {
      key: 'url',
      title: '渠道链接',
      align: 'center',
    },
    {
      key: 'createdAt',
      title: '创建时间',
      width: 160,
      align: 'center',
    },
    {
      key: 'action',
      title: '操作',
      align: 'center',
      width: 300,
      render: (h, params) => {
        const props = {
          type: 'primary',
        };
        const style = {
          display: 'inline-block',
          margin: '5px',
        };
        const btnArr = [
          h(
            'Button',
            {
              props,
              style,
              on: {
                click: () => {
                  const oInput = document.createElement('input');
                  oInput.value = params.row.url;
                  document.body.appendChild(oInput);
                  oInput.select(); // 选择对象;
                  document.execCommand('Copy'); // 执行浏览器复制命令
                  oInput.remove();
                },
              },
            },
            '复制链接'
          ),
          h(
            'Button',
            {
              props,
              style,
              on: {
                click: async () => {
                  await this.stopCooperation(params.row.channelNo);
                  this.getChildList();
                },
              },
            },
            '停止合作'
          ),
        ];
        return h('div', {}, btnArr);
      },
    },
  ];
};
export const kaOwnerList = [
  { key: 2, desc: '商务运营团队' },
  { key: 3, desc: '流量商务团队' },
  { key: 1, desc: '增长团队' },
  { key: 0, desc: '其他' },
];
