import config from '../../config';
import qs from 'qs';
const { appApi } = config;

export default {
  // 小咩分部分
  // 任务类型 下拉列表
  getEventList() {
    return http.get(`${appApi}/api/kdsp/op/userBenefits/user-benefits-event/event_list`);
  },
  // 任务名称
  eventDetailList(params) {
    return http.get(`${appApi}/api/kdsp/op/userBenefits/user-benefits-event/event_detail_list?event_type=${params}`);
  },
  // 小咩分--增加小咩分规则 提交按钮
  addRule(params) {
    return http.post(`${appApi}/api/kdsp/op/userBenefits/user-benefits-rule/add_rule`, qs.stringify(params));
  },
  // 查询规则列表
  getQueryList(params) {
    return http.get(`${appApi}/api/kdsp/op/userBenefits/user-benefits-rule/query_List?${qs.stringify(params)}`);
  },
  //   小咩分规则--修改状态
  updateStatus(params) {
    return http.get(`${appApi}/api/kdsp/op/userBenefits/user-benefits-rule/update_status?ids=${params.ids}&enable=${params.enable}`);
  },
  // 小咩分查看详情
  detailRules(params) {
    return http.get(`${appApi}/api/kdsp/op/userBenefits/user-benefits-rule/detail?id=${params.id}`);
  },
  // 编辑更新
  updateRule(params) {
    return http.post(`${appApi}/api/kdsp/op/userBenefits/user-benefits-rule/update_rule`, qs.stringify(params));
  },

  // 小咩分明细部分
  // 小咩分搜索列表页
  detailUpdateStatus(params) {
    return http.get(`${appApi}/api/kdsp/op/userBenefits/user-benefits-detail/query_List?${qs.stringify(params)}`);
  },
};
