import config from '../../config';
import qs from 'qs';
const { appApi } = config;
// 显示配置
export default {
  search(params) {
    for (const key in params) {
      if (!params[key]) {
        delete params[key];
      }
    }
    return http.post(`${appApi}/api/kdsp/app/app-config-push/list`, params);
  },
  add(params) {
    return http.post(`${appApi}/api/kdsp/app/app-config-push/save`, params);
  },
  update(params) {
    return http.post(`${appApi}/api/kdsp/app/app-config-push/update`, params);
  },
  find(params) {
    return http.get(`${appApi}/api/kdsp/app/app-config-push/find?id=${params}`);
  },
  delItem(params) {
    return http.post(`${appApi}/api/kdsp/app/app-config-item/delete`, params);
  },
  whiteList(params) {
    return http.post(`${appApi}/api/kdsp/app/app-config-push/white-list/save`, qs.stringify(params));
  },
};
