import config from '../../config';
const { appApi } = config;
// const appApi = 'http://192.168.29.89:8097';
// 显示配置
export default {
  // 系统发放优惠券

  systemSendCoupon(params) {
    return http.post(`${appApi}/api/kdsp/op/coupon/receiver/system-send-post`, params, {
      headers: {
        'Content-Type': 'application/json',
      },
    });
  },
  // 优惠券使用列表
  usedList(params) {
    return http.post(`${appApi}/api/kdsp/op/coupon/used/list`, params, {
      headers: {
        'Content-Type': 'application/json',
      },
    });
  },
  // 批量发放上传文件
  upload(params) {
    const form = new FormData();
    form.append('file', params.file);
    form.append('overWrite', params.overWrite);
    form.append('couponId', params.couponId);
    form.append('queryUser', params.queryUser);
    return http.post(`${appApi}/api/kdsp/op/coupon/receiver/excel/upload`, form);
  },
  // 获取文件处理状态
  getProcess(params) {
    return http.get(`${appApi}/api/kdsp/op/coupon/receiver/excel/upload-process-result?couponId=${params.couponId}`);
  },
  // 下载结果
  downResult(params) {
    return http.get(`${appApi}/api/kdsp/op/coupon/receiver/excel/failed-result?couponId=${params.couponId}`).then(res => {
      const data = res.fileUrl;
      window.location.href = data;
    });
  },
  // 优惠券领取列表
  receiverList(params) {
    return http.post(`${appApi}/api/kdsp/op/coupon/receiver/list`, params, {
      headers: {
        'Content-Type': 'application/json',
      },
    });
  },
  couponUpdate(params) {
    return http.post(`${appApi}/api/kdsp/op/coupon/status/update`, params);
  },
  // 优惠券编辑更新
  addEdit(params) {
    return http.post(`${appApi}/api/kdsp/op/coupon/add-edit`, params, {
      headers: {
        'Content-Type': 'application/json',
      },
    });
  },
  // 后端类目查询接口
  categoryQuery() {
    return http.get(`${appApi}/api/kdsp/op/rear-category/query/all`);
  },
  // 用户领取的优惠券冻结解冻(是否可用)
  receiverUpdate(params) {
    return http.post(`${appApi}/api/kdsp/op/coupon/receiver/update`, params);
  },
  // 优惠券搜索列表
  couponList(params) {
    return http.post(`${appApi}/api/kdsp/op/coupon/list`, params, {
      headers: {
        'Content-Type': 'application/json',
      },
    });
  },
  labelInfoList() {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/label-info/list`);
  },
  // 优惠券消费记录页面导出
  download(params) {
    return http.post(`${appApi}/api/kdsp/op/coupon/used/list/export-excel`, params).then(res => {
      const data = res.downloadUrl;
      window.location.href = data;
    });
  },
};
