export const ruleValidate = {
  type: { required: true, message: '请选择组件类型', trigger: 'change', type: 'number' },
  timeSelectionFormat: { required: true, message: '请选择组件类型', trigger: 'change', type: 'number' },
  name: { required: true, message: '请输入模版名称', trigger: 'change' },
  msg: { required: true, message: '请输入提示语', trigger: 'change' },
  imgBanner: { required: true, message: '请上传图片', trigger: 'change', type: 'array' },
  couponMutex: {
    required: true,
    message: '请选择优惠券互斥',
    trigger: 'change',
    type: 'number',
  },
  typeAmt: {
    required: true,
    message: '请选择活动方式',
    trigger: 'change',
    type: 'number',
  },
  limitAmt: {
    required: true,
    message: '请设置活动规则',
    trigger: 'change',
    type: 'number',
    pattern: /^0\.([1-9]|\d[1-9])$|^[1-9]\d{0,8}\.\d{0,2}$|^[1-9]\d{0,8}$/,
  },
  deductAmt: {
    required: true,
    message: '请设置活动规则',
    trigger: 'change',
    type: 'number',
    pattern: /^0\.([1-9]|\d[1-9])$|^[1-9]\d{0,8}\.\d{0,2}$|^[1-9]\d{0,8}$/,
  },
  num: {
    required: true,
    message: '请输入商品折价购买最少邀请新用户',
    trigger: 'blur',
    type: 'number',
  },
  singleHelpNum: {
    required: true,
    message: '请输入助力次数',
    trigger: 'blur',
    type: 'number',
  },
  bgcolor: {
    required: true,
    message: '请输入背景色',
    trigger: 'blur',
  },
  img: {
    required: true,
    message: '请上传图片',
    trigger: 'change',
    type: 'array',
  },
  // allCategory: {
  //   required: true,
  //   message: '请选择是否生效',
  //   trigger: 'blur',
  // },
  groupBuyCnt: {
    required: true,
    message: '请输入数量',
    trigger: 'blur',
    type: 'number',
  },
  groupBuyNewUserLowLimit: {
    required: true,
    message: '请输入数量',
    trigger: 'blur',
    type: 'number',
  },
  groupBuyMaxOpenCnt: {
    required: true,
    message: '请输入数量',
    trigger: 'blur',
    type: 'number',
  },
  groupBuyMaxJoinCnt: {
    required: true,
    message: '请输入数量',
    trigger: 'blur',
    type: 'number',
  },
  groupBuyProductMaxOpen: {
    required: true,
    message: '请输入数量',
    trigger: 'blur',
    type: 'number',
  },
  groupBuyAlertPercent: {
    required: true,
    message: '请输入数量',
    trigger: 'blur',
    type: 'number',
  },
  groupBuyVirtualPersonNum: {
    required: true,
    message: '请输入正确的比例',
    trigger: 'blur',
  },
  groupBuyDuration: {
    required: true,
    message: '请输入时长',
    trigger: 'blur',
    type: 'number',
  },
};
const validtorT = (rule, value, call) => {
  if (!value || !value[0]) {
    return call(new Error());
  }
  return call();
};
export const zeroBuyRules = {
  crowdRegionMin: {
    required: true,
    message: '砍价对象',
    trigger: 'blur',
    type: 'integer',
  },
  crowdRegionMax: {
    required: true,
    message: '砍价对象',
    trigger: 'blur',
    type: 'integer',
  },
  ratioRegionMin: {
    required: true,
    message: '砍价比例区间',
    trigger: 'blur',
    type: 'number',
  },
  ratioRegionMax: {
    required: true,
    message: '砍价比例区间',
    trigger: 'blur',
    type: 'number',
  },
  ratioMax: {
    required: true,
    message: '最大砍价比例',
    trigger: 'blur',
    type: 'number',
  },
  specialCase: {
    required: true,
    message: '砍价特例',
    trigger: 'change',
    type: 'number',
  },
  specialCaseNum: {
    required: true,
    message: '特例对象',
    trigger: 'blur',
    type: 'integer',
  },
  specialCaseRatio: {
    required: true,
    message: '特例比例',
    trigger: 'blur',
    type: 'number',
  },
};
export const dynamicRules = {
  img: {
    required: true,
    message: '请上传图片',
    trigger: 'change',
    type: 'array',
  },
  startTimeRange: {
    required: true,
    message: '请选择时间',
    trigger: 'change',
    validator: validtorT,
  },
  startTime: {
    required: true,
    message: '请选择时间time',
    trigger: 'change',
    type: 'date',
  },
  bgcolor: {
    required: true,
    message: '请输入背景色',
    trigger: 'change',
  },
  activityGoodsSpecialId: {
    required: true,
    message: '请选择专题商品列表',
    trigger: 'change',
    type: 'number',
  },
  limitQuantity: {
    required: true,
    message: '请输入数量',
    trigger: 'blur',
    type: 'number',
  },
};
export const type = [
  // 1.秒杀,2.品类满减,3.商品满减
  {
    title: '秒杀',
    value: 1,
  },
  {
    title: '品类满减',
    value: 2,
  },
  {
    title: '商品满减',
    value: 3,
  },
  {
    title: '0元购',
    value: 4,
  },
  {
    title: '特价活动',
    value: 6,
  },
  {
    title: '百人团-0元购',
    value: 7,
  },
];
export const timeList = [
  {
    title: '日期选择器',
    value: 0,
  },
  {
    title: '时间选择器',
    value: 1,
  },
];
export const activitList = [
  {
    title: '秒杀类型',
    value: 1,
  },
  {
    title: '品类满减',
    value: 2,
  },
  {
    title: '商品满减',
    value: 3,
  },
  {
    title: '0元购',
    value: 4,
  },
  {
    title: '特价活动',
    value: 6,
  },
  {
    title: '拼团-0元购',
    value: 7,
  },
];
export const typeList = [
  {
    title: '商品满减',
    value: 3,
  },
];
export const statusAndEnable = [
  // status:1=待发布,2.已上架.3.已下架
  {
    title: '待发布',
    value: 1,
  },
  {
    title: '已上架',
    value: 2,
  },
  {
    title: '已下架',
    value: 3,
  },
];
export const statusList = [
  // 1=待发布,2.发布.3.下架
  {
    title: '待发布',
    value: 1,
  },
  {
    title: '发布',
    value: 2,
  },
  {
    title: '已下架',
    value: 3,
  },
];
// export const kaChannelList = [
//   {
//     title: '161033+返利网',
//     value: 1,
//   },
//   {
//     title: '161000+58同城',
//     value: 2,
//   },
//   {
//     title: '161034+新橙',
//     value: 3,
//   },
// ];
export const couponType = [
  {
    title: '每满xx减xx',
    value: 0,
  },
  {
    title: '满xx减xxx',
    value: 1,
  },
];
export const specialType = [
  {
    title: '前x件特价，超过原价',
    value: 10,
  },
  // {
  //   title: '买x赠x',
  //   value: 11,
  // },
  // {
  //   title: '第x件x折',
  //   value: 12,
  // },
];
export const specialText = ['前', '买', '第', '件特价，超过原价', '赠', '件'];
