/**
 * Created by sunxiaoying on 2017/12/1.
 */
import Vue from 'vue';
import Vuex from 'vuex';
Vue.use(Vuex);

const state = {
  // 商品列表查询表单
  search: {
    categoryId: undefined,
    category1: '-1',
    category2: '-1',
    category3: '-1',
    productId: undefined,
    productName: undefined,
    supplierId: undefined,
    status: undefined,
    minSellPrice: undefined,
    maxSellPrice: undefined,
    brandId: undefined,
    beginTime: undefined,
    endTime: undefined,
    page: 0, // 0代表第1页
    limit: 20,
  },

  // 商品分类页面  数结构
  category: {
    id: null,
    categoryName: null,
    type: '',
    level: 0,
  },

  // 商品分类页面  nodes节点展开的id数据
  nodesId: {
    parentId: null, // （0级）根节点 id
    id: null, // （一级）子节点 id
    childId: null, // （二级）子节点 id
  },
  settleData: {}, // 巧盼结算数据
};
const mutations = {
  modifyForm(state, newForm) {
    state.search = newForm;
  },
  modifyCategory(state, newValue) {
    state.category = newValue;
  },
  modifyId(state, newId) {
    state.nodesId = newId;
  },
  setSettleData(state, obj) {
    const { arr, key } = obj;
    const data = state.settleData;
    data[key] = arr;
  },
  initSettleData(state) {
    state.settleData = {};
  },
};

const getters = {
  category: function(state) {
    return state.category;
  },
  getSettleData(state) {
    const data = state.settleData;
    return data;
  },
};

export default new Vuex.Store({
  state,
  mutations,
  getters,
});
