import qs from 'qs';
import config from '../../config';
const { appApi } = config;

// 用户分群
export default {
  // 新增
  saveCrowd(params) {
    return http.post(`${appApi}/api/kdsp/op/crowd/saveCrowd`, params);
  },
  // 更新
  updateCrowd(params) {
    return http.post(`${appApi}/api/kdsp/op/crowd/updateCrowd`, params);
  },
  // 详情
  infoCrowd(params) {
    return http.post(`${appApi}/api/kdsp/op/crowd/info`, qs.stringify(params));
  },
  // 查询
  getCrowdList(params) {
    return http.post(`${appApi}/api/kdsp/op/crowd/getCrowdList`, qs.stringify(params));
  },
  // 地区列表
  addressList() {
    return http.get(`${appApi}/api/kdsp/op/crowd/address/list`);
  },
  channelList(params) {
    return http.get(`${appApi}/api/kdsp/op/crowd/channel/list?${qs.stringify(params)}`);
  },
};
