import config from '../../config';
const { appApi } = config;
import qs from 'qs';
// 显示配置
export default {
  search(params) {
    for (const key in params) {
      if (!params[key]) {
        delete params[key];
      }
    }
    return http.post(`${appApi}/api/kdsp/app/app-config/list`, params);
  },
  add(params) {
    return http.post(`${appApi}/api/kdsp/app/app-config/add`, params, {
      headers: { Account: 'yapi' },
    });
  },
  update(params) {
    return http.post(`${appApi}/api/kdsp/app/app-config/update`, params, {
      headers: { Account: 'yapi' },
    });
  },
  find(params) {
    return http.post(`${appApi}/api/kdsp/app/app-config/find`, params);
  },
  delItem(params) {
    return http.post(`${appApi}/api/kdsp/app/app-config-item/delete`, params);
  },
  activityList(params) {
    return http.get(`${appApi}/api/kdsp/activity/activity-info/list-current-valid?${qs.stringify(params)}`);
  },
  labelList() {
    return http.post(`${appApi}/api/kdsp/activity/activity-goods/label-info/list`);
  },
  skuList(params) {
    // console.log(params, 'params');
    return http.post(`${appApi}/api/kdsp/sku/sku-info/sku-list`, params);
  },
  secActivityList(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-info/current-valid-activity`, params, {
      headers: {
        'Content-Type': 'application/json',
      },
    });
  },
  addTop(params) {
    return http.post(`${appApi}/api/kdsp/index/top-tab/save`, params, {
      headers: { Account: 'yapi' },
    });
  },
  updateTop(params) {
    return http.put(`${appApi}/api/kdsp/index/top-tab/update`, params, {
      headers: { Account: 'yapi' },
    });
  },
  getList(params) {
    return http.post(`${appApi}/api/kdsp/index/top-tab/list-page`, params, {
      headers: {
        'Content-Type': 'application/json',
      },
    });
  },
  detial(params) {
    return http.post(`${appApi}/api/kdsp/index/top-tab/view`, params);
  },
  editSecondNav(params) {
    console.log(params);
    return http.post(`${appApi}/api/kdsp/index/top-tab/save2`, params, {
      headers: { Account: 'yapi' },
    });
  },
};
