/**
 * Created by sunxiaoying on 2017/7/21.
 */
import config from '../../config';
import qs from 'qs';
const { appApi } = config;
// const appApi = 'http://192.168.28.41';
// 显示配置
export default {
  // 新增积分任务
  taskAdd(params) {
    return http.post(`${appApi}/api/kdsp/points/task/add`, params, {
      headers: {
        'Content-Type': 'application/json',
      },
    });
  },
  // 积分任务状态变更
  statusSwitch(params) {
    return http.post(`${appApi}/api/kdsp/points/task/status/switch?taskId=${params.taskId}`);
  },

  // 积分列表查询
  pointUrl(params) {
    return http.post(`${appApi}/api/kdsp/points/task/list`, params, {
      headers: {
        'Content-Type': 'application/json',
      },
    });
  },
  // 积分明细列表查询
  detailList(params) {
    return http.post(`${appApi}/api/kdsp/points/detail/list`, params, {
      headers: {
        'Content-Type': 'application/json',
      },
    });
  },
  // 查询邀请好友记录
  inviteList(params) {
    return http.post(`${appApi}/api/kdsp/invite/list`, params, {
      headers: {
        'Content-Type': 'application/json',
      },
    });
  },
  // 查询完成结点
  nodeList() {
    return http.get(`${appApi}/api/kdsp/points/task/node/list`);
  },
  // 获取任务列表
  // getEventList() {
  //   return http.get(`${appApi}/api/kdsp/op/userBenefits/user-benefits-event/event_list`);
  // },
  // 获取任务名称
  // getEventNameList(params) {
  //   return http.get(`${appApi}/api/kdsp/op/userBenefits/user-benefits-event/event_detail_list?event_type=${params}`);
  // },
  // 新增任务确认
  // addNewEvent(params) {
  //   return http.post(`${appApi}/api/kdsp/op/userBenefits/user-benefits-rule/add_rule`, params);
  // },
  // 发布下线
  updatesOffline(params) {
    return http.get(`${appApi}/api/kdsp/op/userBenefits/user-benefits-point-level/update_status?ids=${params.ids}&enable=${params.enable}`);
  },
  // 会员等级列表获取
  memberLevelList(params) {
    return http.get(`${appApi}/api/kdsp/op/userBenefits/user-benefits-point-level/query_List`, params);
  },
  // 新增会员等级
  addNewLevel(params) {
    return http.post(`${appApi}/api/kdsp/op/userBenefits/user-benefits-point-level/add_level`, qs.stringify(params), {
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded',
      },
    });
  },
  // 会员等级查看详情
  detailLevel(params) {
    return http.get(`${appApi}/api/kdsp/op/userBenefits/user-benefits-point-level/detail?id=${params}`);
  },
  // 会员等级编辑确定
  editNewLevel(params) {
    return http.post(`${appApi}/api/kdsp/op/userBenefits/user-benefits-point-level/update_level`, qs.stringify(params));
  },
  // 会员权益获取列表页
  queryRightList(params) {
    return http.get(`${appApi}/api/kdsp/op/userBenefits/user-benefits-point-level-attr/query_List?pageNo=${params.pageNo}&pageSize=${params.pageSize}`);
  },
  // 会员权益更新状态
  updateStatus(params) {
    return http.get(`${appApi}/api/kdsp/op/userBenefits/user-benefits-point-level-attr/update_status?ids=${params.ids}&enable=${params.enable}`);
  },
  // 会员权益获取等级名称
  getLevelList() {
    return http.get(`${appApi}/api/kdsp/op/userBenefits/user-benefits-point-level-attr/query_level_list`);
  },
  // 会员权益获取权益名称
  getRightList() {
    return http.get(`${appApi}/api/kdsp/op/userBenefits/user-benefits-point-level-attr/benefits_list_detail`);
  },
  // 会员权益编辑获取系统反显
  detailRight(params) {
    return http.get(`${appApi}/api/kdsp/op/userBenefits/user-benefits-point-level-attr/detail?id=${params}`);
  },
  getCouponList(params) {
    return http.post(`${appApi}/api/kdsp/op/coupon/list`, params);
  },
  // 新增会员权益
  addNewRight(params) {
    return http.post(`${appApi}/api/kdsp/op/userBenefits/user-benefits-point-level-attr/add_attr`, qs.stringify(params));
  },
  // 更新会员权益
  updateRight(params) {
    return http.post(`${appApi}/api/kdsp/op/userBenefits/user-benefits-point-level-attr/update_attr`, qs.stringify(params));
  },
};
